<?php
/**
 * ============================================================
 * مهمة أسبوعية - تصفير العدادات الأسبوعية
 * ============================================================
 * 
 * تُنفذ: كل يوم سبت عند منتصف الليل (00:00)
 * 
 * Cron Command (cPanel):
 *   0 0 * * 6 /usr/bin/php /home/username/public_html/cron/weekly_reset.php
 * 
 * الوظائف:
 *   1. تصفير عدادات توليد الأكواد الأسبوعية
 */

if (php_sapi_name() !== 'cli' && !defined('CRON_ALLOWED')) {
    http_response_code(403);
    exit('CLI only');
}

define('BOT_STARTED', true);
define('BOT_TYPE', 'cron');

require __DIR__ . '/../libs/bootstrap.php';

$startTime = microtime(true);

echo "=== Weekly Reset Cron Job ===\n";
echo "Started at: " . date('Y-m-d H:i:s') . "\n\n";

try {
    // تصفير العدادات الأسبوعية (Idempotent)
    echo "Resetting weekly activation counters...\n";
    
    // YYYYWW format - سنة + رقم الأسبوع
    $currentWeek = date('oW');
    
    // التصفير فقط إذا لم يُصفَّر هذا الأسبوع
    $affected = Db::execute(
        "UPDATE superdist_accounts 
         SET activations_this_week = 0,
             last_weekly_reset = ?
         WHERE last_weekly_reset IS NULL OR last_weekly_reset != ?",
        [$currentWeek, $currentWeek]
    );
    
    echo "   - Reset {$affected} records (Week: {$currentWeek})\n";
    
    Logger::event('cron_executed', 'system', null, null, null, [
        'job'     => 'weekly_reset',
        'week'    => $currentWeek,
        'results' => ['Weekly counters reset: ' . $affected],
    ]);
    
} catch (Throwable $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    Logger::error('Weekly cron failed', ['error' => $e->getMessage()]);
}

$duration = round((microtime(true) - $startTime) * 1000, 2);
echo "\nCompleted in {$duration}ms\n";
