<?php
/**
 * ============================================================
 * مهمة شهرية - تصفير العدادات الشهرية
 * ============================================================
 * 
 * تُنفذ: أول يوم من كل شهر عند منتصف الليل (00:00)
 * 
 * Cron Command (cPanel):
 *   0 0 1 * * /usr/bin/php /home/username/public_html/cron/monthly_reset.php
 * 
 * الوظائف:
 *   1. تصفير عدادات توليد الأكواد الشهرية
 */

if (php_sapi_name() !== 'cli' && !defined('CRON_ALLOWED')) {
    http_response_code(403);
    exit('CLI only');
}

define('BOT_STARTED', true);
define('BOT_TYPE', 'cron');

require __DIR__ . '/../libs/bootstrap.php';

$startTime = microtime(true);

echo "=== Monthly Reset Cron Job ===\n";
echo "Started at: " . date('Y-m-d H:i:s') . "\n\n";

try {
    // تصفير العدادات الشهرية (Idempotent)
    echo "Resetting monthly activation counters...\n";
    
    // YYYYMM format - سنة + شهر
    $currentMonth = date('Ym');
    
    // التصفير فقط إذا لم يُصفَّر هذا الشهر
    $affected = Db::execute(
        "UPDATE superdist_accounts 
         SET activations_this_month = 0,
             last_monthly_reset = ?
         WHERE last_monthly_reset IS NULL OR last_monthly_reset != ?",
        [$currentMonth, $currentMonth]
    );
    
    echo "   - Reset {$affected} records (Month: {$currentMonth})\n";
    
    Logger::event('cron_executed', 'system', null, null, null, [
        'job'     => 'monthly_reset',
        'month'   => $currentMonth,
        'results' => ['Monthly counters reset: ' . $affected],
    ]);
    
} catch (Throwable $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    Logger::error('Monthly cron failed', ['error' => $e->getMessage()]);
}

$duration = round((microtime(true) - $startTime) * 1000, 2);
echo "\nCompleted in {$duration}ms\n";
