<?php
/**
 * ملف اختبار لتشخيص خطأ 500
 * افتح هذا الملف في المتصفح لرؤية الخطأ
 */

// عرض جميع الأخطاء
error_reporting(E_ALL);
ini_set('display_errors', '1');

echo "<h2>اختبار تشغيل بوت الإدارة</h2><pre>";

try {
    echo "1. تعريف الثوابت...\n";
    define('BOT_STARTED', true);
    define('BOT_TYPE', 'admin');
    
    echo "2. تحميل bootstrap.php...\n";
    require __DIR__ . '/libs/bootstrap.php';
    echo "   ✅ تم بنجاح\n";
    
    echo "3. تحميل Commands.php...\n";
    require __DIR__ . '/src/admin/Commands.php';
    echo "   ✅ تم بنجاح\n";
    
    echo "\n✅ جميع الملفات تم تحميلها بنجاح!\n";
    echo "\nمعلومات قاعدة البيانات:\n";
    
    // اختبار الاتصال
    $testQuery = Db::fetchValue("SELECT 1");
    echo "   اتصال DB: " . ($testQuery ? '✅' : '❌') . "\n";
    
} catch (Throwable $e) {
    echo "\n❌ خطأ!\n";
    echo "الرسالة: " . $e->getMessage() . "\n";
    echo "الملف: " . $e->getFile() . "\n";
    echo "السطر: " . $e->getLine() . "\n";
    echo "\nStack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "</pre>";
