<?php
/**
 * ============================================================
 * أوامر بوت الإدارة (Admin Commands)
 * ============================================================
 */

// تحميل فئات نظام إدارة صلاحيات الوصول
require_once __DIR__ . '/BatchAccessCommands.php';

class AdminCommands
{
    /**
     * معالجة الأمر الوارد
     */
    public static function handle(string $command, string $args, int $fromId, int $chatId, array $message): void
    {
        switch ($command) {
            // أوامر عامة
            case '/start': self::cmdStart($chatId); break;
            case '/help':
            case '/admin_help': self::cmdHelp($chatId, $args); break;
            
            // أوامر المساعدة التفصيلية
            case '/help_accounts': self::cmdHelp($chatId, 'accounts'); break;
            case '/help_superdists': self::cmdHelp($chatId, 'superdists'); break;
            case '/help_limits': self::cmdHelp($chatId, 'limits'); break;
            case '/help_users': self::cmdHelp($chatId, 'users'); break;
            case '/help_replies': self::cmdHelp($chatId, 'replies'); break;
            case '/help_bans': self::cmdHelp($chatId, 'bans'); break;
            case '/help_reports': self::cmdHelp($chatId, 'reports'); break;
            case '/help_broadcast': self::cmdHelp($chatId, 'broadcast'); break;
            case '/help_vouchers': self::cmdHelp($chatId, 'vouchers'); break;
            case '/help_system': self::cmdHelp($chatId, 'system'); break;
            case '/help_blacklist': self::cmdHelp($chatId, 'blacklist'); break;
            case '/help_access': self::cmdHelp($chatId, 'access'); break;
            case '/cancel': State::clear($fromId); Telegram::sendMessage($chatId, "❌ تم الإلغاء."); break;
            
            // إدارة الحسابات
            case '/addaccount': self::cmdAddAccount($chatId, $args); break;
            case '/editaccount': self::cmdEditAccount($chatId, $args); break;
            case '/deleteaccount': self::cmdDeleteAccount($chatId, $args, $fromId); break;
            case '/listaccounts': self::cmdListAccounts($chatId); break;
            case '/accountinfo': self::cmdAccountInfo($chatId, $args); break;
            case '/setaccountkey': self::cmdSetAccountKey($chatId, $args); break;
            case '/setaccountlimits': self::cmdSetAccountLimits($chatId, $args); break;
            
            // إدارة السوبر موزعين
            case '/addsuperdist': self::cmdAddSuperDist($chatId, $args); break;
            case '/listsuperdists': self::cmdListSuperDists($chatId, $args); break;
            case '/superdistinfo': self::cmdSuperDistInfo($chatId, $args); break;
            case '/editsuperdist': self::cmdEditSuperDist($chatId, $args); break;
            case '/deletesuperdist': self::cmdDeleteSuperDist($chatId, $args); break;
            case '/setsuperdistaccounts': self::cmdSetSuperDistAccounts($chatId, $args); break;
            case '/setsuperdistaccountperiod': self::cmdSetSuperDistAccountPeriod($chatId, $args); break;
            case '/suspendsuperdist': self::cmdSuspendSuperDist($chatId, $args); break;
            case '/activatesuperdist': self::cmdActivateSuperDist($chatId, $args); break;
            case '/archivesuperdist': self::cmdArchiveSuperDist($chatId, $args); break;
            case '/createsuperdistcode': self::cmdCreateSuperDistCode($chatId, $args); break;
            case '/check_code': self::cmdCheckCode($chatId, $args); break;
            
            // إدارة الحدود - عرض
            case '/viewgloballimits': self::cmdViewGlobalLimits($chatId); break;
            case '/viewaccountlimits': self::cmdViewAccountLimits($chatId, $args); break;
            case '/viewsuperdistlimits': self::cmdViewSuperDistLimits($chatId, $args); break;
            case '/viewuserlimits': self::cmdViewUserLimits($chatId, $args); break;
            
            // إدارة الحدود - تعيين
            case '/setgloballimits': self::cmdSetGlobalLimits($chatId, $args); break;
            case '/setsuperdistlimits': self::cmdSetSuperDistLimits($chatId, $args); break;
            case '/setuserlimits': self::cmdSetUserLimits($chatId, $args); break;
            case '/setuseraccountlimits': self::cmdSetUserAccountLimits($chatId, $args); break;
            
            // معالجة الأكواد والإعدادات
            case '/process_codes_window': self::cmdProcessCodesWindow($chatId, $args, $fromId); break;
            case '/set_setting': self::cmdSetSetting($chatId, $args, $fromId); break;
            case '/get_setting': self::cmdGetSetting($chatId, $args); break;
            case '/view_settings': self::cmdViewSettings($chatId, $args); break;
            
            // إدارة اشتراكات الزبائن
            case '/userinfo': self::cmdUserInfo($chatId, $args); break;
            case '/setuseraccount_lifetime': self::cmdSetUserAccountLifetime($chatId, $args); break;
            case '/setuseraccount_period': self::cmdSetUserAccountPeriod($chatId, $args); break;
            case '/convert_lifetime_to_period': self::cmdConvertLifetimeToPeriod($chatId, $args); break;
            case '/removeuseraccount': self::cmdRemoveUserAccount($chatId, $args); break;
            
            // إدارة الردود
            case '/listreplies': self::cmdListReplies($chatId); break;
            case '/setreply': self::cmdSetReply($chatId, $args, $fromId); break;
            case '/setsuperdistreply': self::cmdSetSuperDistReply($chatId, $args, $fromId); break;
            case '/testreply': self::cmdTestReply($chatId, $args); break;
            
            // الحظر
            case '/ban_user': self::cmdBanUser($chatId, $args, $fromId); break;
            case '/unban_user': self::cmdUnbanUser($chatId, $args, $fromId); break;
            case '/ban_superdist': self::cmdBanSuperDist($chatId, $args, $fromId); break;
            case '/unban_superdist': self::cmdUnbanSuperDist($chatId, $args, $fromId); break;
            
            // صلاحيات البث للسوبر موزع
            case '/setsuperdistbroadcast': self::cmdSetSuperDistBroadcast($chatId, $args); break;
            case '/superdist_broadcast_allowed': self::cmdSuperDistBroadcastAllowed($chatId, $args); break;
            case '/superdist_broadcast_logs': self::cmdSuperDistBroadcastLogs($chatId, $args); break;
            case '/broadcast_log_view': self::cmdBroadcastLogView($chatId, $args); break;
            case '/superdist_broadcast_info': self::cmdSuperDistBroadcastInfo($chatId, $args); break;
            
            // التصدير
            case '/export_logs': self::cmdExportLogs($chatId, $args); break;
            case '/export_codes': self::cmdExportCodes($chatId, $args); break;
            
            // التقارير
            case '/system_stats': self::cmdSystemStats($chatId); break;
            case '/superdist_stats': self::cmdSuperDistStats($chatId, $args); break;
            case '/superdist_log': self::cmdSuperDistLog($chatId, $args); break;
            case '/user_info': self::cmdUserInfo($chatId, $args); break;
            
            // البث
            case '/broadcast_all': self::cmdBroadcast($chatId, $fromId, 'all'); break;
            case '/broadcast_users': self::cmdBroadcast($chatId, $fromId, 'users'); break;
            case '/broadcast_superdists': self::cmdBroadcast($chatId, $fromId, 'superdists'); break;
            case '/broadcast_superdist_users': self::cmdBroadcast($chatId, $fromId, 'superdist_users', $args); break;
            
            // ═══════════════════════════════════════════════════════════
            // الأوامر الجديدة (V2)
            // ═══════════════════════════════════════════════════════════
            
            // نظام القسائم
            case '/create_voucher': self::cmdCreateVoucher($chatId, $args, $fromId); break;
            case '/voucher_info': self::cmdVoucherInfo($chatId, $args); break;
            case '/list_vouchers': self::cmdListVouchers($chatId, $args); break;
            case '/disable_voucher': self::cmdDisableVoucher($chatId, $args); break;
            
            // إضافة حسابات دفعة واحدة
            case '/addaccounts_batch': self::cmdAddAccountsBatch($chatId, $args, $fromId); break;
            
            // فحص النظام
            case '/run_system_check': self::cmdRunSystemCheck($chatId, $args, $fromId); break;
            case '/system_reports': self::cmdSystemReports($chatId, $args); break;
            case '/view_report': self::cmdViewReport($chatId, $args); break;
            
            // إدارة القائمة السوداء للبث
            case '/blacklist_add': self::cmdBlacklistAdd($chatId, $args, $fromId); break;
            case '/blacklist_remove': self::cmdBlacklistRemove($chatId, $args); break;
            case '/blacklist_list': self::cmdBlacklistList($chatId); break;
            
            // إعدادات البث
            case '/broadcast_settings': self::cmdBroadcastSettings($chatId, $args); break;
            case '/set_broadcast_setting': self::cmdSetBroadcastSetting($chatId, $args); break;
            
            // إدارة صلاحيات الوصول الدفعي
            case '/set_users_access': BatchAccessCommands::cmdSetUsersAccess($chatId, $args, $fromId); break;
            case '/set_default_account_access': BatchAccessCommands::cmdSetDefaultAccountAccess($chatId, $args, $fromId); break;
            case '/get_default_account_access': BatchAccessCommands::cmdGetDefaultAccountAccess($chatId, $args); break;
            case '/list_accounts_with_default_inherit': BatchAccessCommands::cmdListAccountsWithDefaultInherit($chatId, $args); break;
            case '/batch_operation_status': BatchAccessCommands::cmdBatchOperationStatus($chatId, $args); break;
            
            // البثات المحظورة
            case '/blocked_broadcasts': self::cmdBlockedBroadcasts($chatId, $args); break;
            
            default:
                Telegram::sendMessage($chatId, "❓ أمر غير معروف: {$command}\n\nاستخدم /help لعرض الأوامر.");
        }
    }
    
    // ================================================================
    // أوامر عامة
    // ================================================================
    
    private static function cmdStart(int $chatId): void
    {
        Telegram::sendMessage($chatId, "🤖 <b>مرحباً بك في بوت الإدارة</b>\n\n📋 استخدم /help لعرض الأوامر.");
    }
    
    private static function cmdHelp(int $chatId, string $section = ''): void
    {
        $section = strtolower(trim($section));
        
        if ($section === '' || $section === 'main') {
            $text = "📋 <b>أوامر الإدارة</b>\n\n";
            $text .= "📦 /help_accounts - إدارة الحسابات\n";
            $text .= "👥 /help_superdists - السوبر موزعين\n";
            $text .= "⚙️ /help_limits - الحدود\n";
            $text .= "👤 /help_users - اشتراكات الزبائن\n";
            $text .= "💬 /help_replies - الردود\n";
            $text .= "🚫 /help_bans - الحظر\n";
            $text .= "📊 /help_reports - التقارير\n";
            $text .= "📢 /help_broadcast - البث\n";
            $text .= "🎟️ /help_vouchers - القسائم\n";
            $text .= "🔧 /help_system - فحص النظام\n";
            $text .= "🚷 /help_blacklist - القائمة السوداء\n";
            $text .= "🔑 /help_access - إدارة صلاحيات الوصول\n";
        } elseif ($section === 'accounts') {
            $text = "📦 <b>إدارة الحسابات</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ إضافة حساب جديد</b>\n";
            $text .= "<code>/addaccount slug | name | secret_key</code>\n";
            $text .= "📝 <b>الشرح:</b> إضافة حساب جديد للنظام\n";
            $text .= "📌 <b>مثال:</b>\n<code>/addaccount vip-acc | حساب VIP | abc123</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>تم إضافة الحساب!\n• ID: 5\n• Slug: vip-acc</i>\n";
            $text .= "⚠️ <b>ملاحظات:</b> الـ slug يجب أن يكون فريداً وبأحرف إنجليزية\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ إضافة حسابات دفعة واحدة</b>\n";
            $text .= "<code>/addaccounts_batch [--preview]</code>\n";
            $text .= "📝 <b>الشرح:</b> إضافة عدة حسابات من ملف CSV\n";
            $text .= "📌 <b>صيغة CSV:</b>\n<code>name,slug,secret_key,access_type,access_days\nحساب 1,acc-1,KEY123,lifetime,\nحساب 2,acc-2,KEY456,timed,30</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>📊 نجاح: 2 | فشل: 0</i>\n";
            $text .= "⚠️ <b>ملاحظات:</b>\n• --preview يعرض المعاينة بدون تنفيذ\n• secret_key مطلوب لكل حساب\n• access_days مطلوب إذا كان timed\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ تعديل حساب</b>\n";
            $text .= "<code>/editaccount [id|slug] name=... slug=...</code>\n";
            $text .= "📝 <b>الشرح:</b> تعديل اسم أو معرّف الحساب\n";
            $text .= "📌 <b>مثال:</b>\n<code>/editaccount 5 name=حساب VIP الجديد</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>تم تحديث الحساب 5\n• الاسم: حساب VIP الجديد</i>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>4️⃣ حذف حساب</b>\n";
            $text .= "<code>/deleteaccount [id|slug] confirm</code>\n";
            $text .= "📝 <b>الشرح:</b> حذف حساب نهائياً\n";
            $text .= "📌 <b>مثال:</b>\n<code>/deleteaccount test-acc confirm</code>\n";
            $text .= "⚠️ <b>ملاحظات:</b> لا يمكن حذف حساب مرتبط بموزعين أو أكواد\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>5️⃣ قائمة الحسابات</b>\n";
            $text .= "<code>/listaccounts</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض جميع الحسابات\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>6️⃣ معلومات حساب</b>\n";
            $text .= "<code>/accountinfo [id|slug]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض تفاصيل حساب معين\n";
            $text .= "📌 <b>مثال:</b>\n<code>/accountinfo vip-acc</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>7️⃣ تغيير المفتاح السري</b>\n";
            $text .= "<code>/setaccountkey [id] [secret_key]</code>\n";
            $text .= "📝 <b>الشرح:</b> تغيير مفتاح التحقق للحساب\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setaccountkey 5 newsecret123</code>\n";
            $text .= "⚠️ <b>ملاحظات:</b> تغيير المفتاح يؤثر على أكواد التحقق\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>8️⃣ حدود الحساب</b>\n";
            $text .= "<code>/setaccountlimits [id|slug] daily=X weekly=Y monthly=Z</code>\n";
            $text .= "📝 <b>الشرح:</b> تعيين حدود التحقق لجميع مستخدمي الحساب\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setaccountlimits vip-acc daily=5 weekly=30</code>\n";
            $text .= "⚠️ <b>ملاحظات:</b> أولوية هذه الحدود 3.5 (بين الموزع والعام)\n";
        } elseif ($section === 'superdists') {
            $text = "👥 <b>إدارة السوبر موزعين</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ إضافة سوبر موزع</b>\n";
            $text .= "<code>/addsuperdist telegram_id | display_name</code>\n";
            $text .= "📝 <b>الشرح:</b> إضافة سوبر موزع جديد للنظام\n";
            $text .= "📌 <b>مثال:</b>\n<code>/addsuperdist 123456789 | أحمد الموزع</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>✅ تم إضافة السوبر موزع!\n• ID: 5\n• TG: 123456789\n• الاسم: أحمد الموزع</i>\n";
            $text .= "⚠️ <b>ملاحظات:</b> الموزع يُنشأ بحالة active بدون حسابات\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ قائمة الموزعين</b>\n";
            $text .= "<code>/listsuperdists [status]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض قائمة الموزعين حسب الحالة\n";
            $text .= "📌 <b>مثال:</b>\n<code>/listsuperdists active</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>👥 الموزعين النشطين (3):\n🟢 #1 أحمد | TG:123...\n🟢 #2 محمد | TG:456...</i>\n";
            $text .= "⚠️ <b>الحالات:</b> active, suspended, banned, archived\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ معلومات موزع</b>\n";
            $text .= "<code>/superdistinfo [id]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض تفاصيل موزع محدد\n";
            $text .= "📌 <b>مثال:</b>\n<code>/superdistinfo 5</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>👤 الموزع #5\n• الاسم: أحمد\n• الحالة: 🟢 نشط\n• الحسابات: VIP, Premium\n• الأكواد: 150 (45 مستخدم)</i>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>4️⃣ تعديل بيانات موزع</b>\n";
            $text .= "<code>/editsuperdist [id] [field]=[value]</code>\n";
            $text .= "📝 <b>الشرح:</b> تعديل بيانات موزع\n";
            $text .= "📌 <b>مثال:</b>\n<code>/editsuperdist 5 name=محمد الموزع</code>\n";
            $text .= "<code>/editsuperdist 5 telegram_id=987654321</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>✅ تم تعديل الموزع #5\n• الحقل: name\n• القيمة الجديدة: محمد الموزع</i>\n";
            $text .= "⚠️ <b>الحقول:</b> name, telegram_id, status\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>5️⃣ حذف موزع نهائياً</b>\n";
            $text .= "<code>/deletesuperdist [id] confirm</code>\n";
            $text .= "📝 <b>الشرح:</b> حذف موزع نهائياً مع جميع بياناته\n";
            $text .= "📌 <b>مثال:</b>\n<code>/deletesuperdist 5 confirm</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>🗑️ تم حذف الموزع #5 نهائياً\n• الأكواد المحذوفة: 150\n• الحسابات: 3</i>\n";
            $text .= "⚠️ <b>تحذير:</b> هذا الإجراء لا يمكن التراجع عنه!\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>6️⃣ ربط حسابات للموزع</b>\n";
            $text .= "<code>/setsuperdistaccounts [id] add [account_ids]</code>\n";
            $text .= "📝 <b>الشرح:</b> ربط حسابات جديدة للموزع\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setsuperdistaccounts 5 add 1,2,3</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>✅ تم ربط 3 حسابات للموزع #5</i>\n";
            $text .= "⚠️ <b>ملاحظات:</b> يجب تحديد فترة بعد الربط\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>7️⃣ تمديد فترة حساب</b>\n";
            $text .= "<code>/setsuperdistaccountperiod [sd_id] [acc_id] [days]</code>\n";
            $text .= "📝 <b>الشرح:</b> تمديد فترة حساب مرتبط بموزع\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setsuperdistaccountperiod 5 1 30</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>✅ تم تمديد الحساب #1 للموزع #5\n• المدة الجديدة: 30 يوم\n• ينتهي: 2025-01-03</i>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>8️⃣ التحكم بالحالة</b>\n";
            $text .= "<code>/suspendsuperdist [id]</code>\n";
            $text .= "📝 <b>الشرح:</b> إيقاف مؤقت (يمكن التفعيل لاحقاً)\n";
            $text .= "📌 <b>مثال:</b>\n<code>/suspendsuperdist 5</code>\n\n";
            $text .= "<code>/activatesuperdist [id]</code>\n";
            $text .= "📝 <b>الشرح:</b> تفعيل موزع موقوف\n\n";
            $text .= "<code>/archivesuperdist [id] [reason?]</code>\n";
            $text .= "📝 <b>الشرح:</b> أرشفة نهائية\n";
            $text .= "⚠️ <b>ملاحظات:</b> الأرشفة لا يمكن التراجع عنها\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>9️⃣ كود اشتراك موزع</b>\n";
            $text .= "<code>/createsuperdistcode [type] [accounts] [days] [uses]</code>\n";
            $text .= "📝 <b>الشرح:</b> إنشاء كود SD-... لموزع جديد أو لتجديد\n";
            $text .= "📌 <b>مثال:</b>\n<code>/createsuperdistcode new 1,2 30 1</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>🎟️ تم إنشاء الكود:\nSD-A1B2-C3D4-E5F6\n• النوع: جديد\n• الحسابات: 1,2\n• المدة: 30 يوم</i>\n";
            $text .= "⚠️ <b>الأنواع:</b> new (موزع جديد), renew (تجديد)\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>🔟 صلاحيات البث</b>\n";
            $text .= "<code>/setsuperdistbroadcast [id] [on|off] [types]</code>\n";
            $text .= "📝 <b>الشرح:</b> تحديد صلاحيات البث للموزع\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setsuperdistbroadcast 5 on text,photos</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>✅ تم تحديث صلاحيات البث للموزع #5\n• البث: مسموح\n• الأنواع: text, photos</i>\n";
            $text .= "⚠️ <b>الأنواع:</b> text, stickers, photos, videos, documents, audio\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣1️⃣ استعلام صلاحيات البث</b>\n";
            $text .= "<code>/superdist_broadcast_allowed [sd_id]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض صلاحيات البث لموزع معين\n";
            $text .= "📌 <b>مثال:</b>\n<code>/superdist_broadcast_allowed 5</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣2️⃣ سجلات البث</b>\n";
            $text .= "<code>/superdist_broadcast_logs [sd_id] [page?]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض سجلات البث لموزع (من الأحدث)\n";
            $text .= "📌 <b>مثال:</b>\n<code>/superdist_broadcast_logs 5</code>\n";
            $text .= "<code>/superdist_broadcast_logs 5 2</code>\n\n";
            
            $text .= "<code>/broadcast_log_view [log_id]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض تفاصيل سجل بث محدد\n";
            $text .= "📌 <b>مثال:</b>\n<code>/broadcast_log_view 1023</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣3️⃣ معلومات بث شاملة</b>\n";
            $text .= "<code>/superdist_broadcast_info [sd_id]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض معلومات البث الشاملة للموزع\n";
            $text .= "📌 <b>مثال:</b>\n<code>/superdist_broadcast_info 5</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>📤 التصدير</b>\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n\n";
            
            $text .= "<code>/export_logs [type] [days?]</code>\n";
            $text .= "📝 <b>الأنواع:</b> activations, broadcasts, errors, system\n";
            $text .= "📌 <b>مثال:</b>\n<code>/export_logs activations 30</code>\n\n";
            
            $text .= "<code>/export_codes [slug] [format?]</code>\n";
            $text .= "📝 <b>الصيغ:</b> txt, csv, zip\n";
            $text .= "📌 <b>مثال:</b>\n<code>/export_codes vip-acc zip</code>\n";
            
        } elseif ($section === 'limits') {
            $text = "⚙️ <b>إدارة الحدود</b>\n\n";
            $text .= "📊 <b>ترتيب الأولوية:</b>\n";
            $text .= "1️⃣ user_account (الأعلى)\n";
            $text .= "2️⃣ user\n";
            $text .= "3️⃣ superdist\n";
            $text .= "3.5️⃣ account\n";
            $text .= "4️⃣ global (الأدنى)\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>📋 عرض الحدود</b>\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n\n";
            
            $text .= "<b>1️⃣ الحدود العامة</b>\n";
            $text .= "<code>/viewgloballimits</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض حدود التحقق العامة\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>⚙️ الحدود العامة:\n• يومي: 10\n• أسبوعي: 50\n• شهري: 200</i>\n\n";
            
            $text .= "<b>2️⃣ حدود الحسابات</b>\n";
            $text .= "<code>/viewaccountlimits [slug?]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض حدود حساب أو جميع الحسابات\n";
            $text .= "📌 <b>مثال:</b>\n<code>/viewaccountlimits vip-acc</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>📦 حدود حساب vip-acc:\n• يومي: 5\n• أسبوعي: 30\n• شهري: 100</i>\n\n";
            
            $text .= "<b>3️⃣ حدود الموزعين</b>\n";
            $text .= "<code>/viewsuperdistlimits [sd_id?]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض حدود موزع أو جميع الموزعين\n";
            $text .= "📌 <b>مثال:</b>\n<code>/viewsuperdistlimits 5</code>\n\n";
            
            $text .= "<b>4️⃣ حدود الزبائن</b>\n";
            $text .= "<code>/viewuserlimits [telegram_id?]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض حدود مستخدم محدد\n";
            $text .= "📌 <b>مثال:</b>\n<code>/viewuserlimits 123456789</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>⚙️ تعيين الحدود</b>\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n\n";
            
            $text .= "<b>5️⃣ الحدود العامة</b>\n";
            $text .= "<code>/setgloballimits daily=X weekly=Y monthly=Z</code>\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setgloballimits daily=10 weekly=50 monthly=200</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>✅ تم تحديث الحدود العامة</i>\n\n";
            
            $text .= "<b>6️⃣ حدود الحساب</b>\n";
            $text .= "<code>/setaccountlimits [slug] daily=X weekly=Y monthly=Z</code>\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setaccountlimits vip-acc daily=5</code>\n";
            $text .= "⚠️ <b>ملاحظات:</b> تنطبق على جميع مستخدمي الحساب\n\n";
            
            $text .= "<b>7️⃣ حدود السوبر موزع</b>\n";
            $text .= "<code>/setsuperdistlimits [sd_id] daily=X weekly=Y monthly=Z</code>\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setsuperdistlimits 5 daily=20</code>\n\n";
            
            $text .= "<b>8️⃣ حدود المستخدم</b>\n";
            $text .= "<code>/setuserlimits [telegram_id] daily=X weekly=Y monthly=Z</code>\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setuserlimits 123456789 daily=5</code>\n\n";
            
            $text .= "<b>9️⃣ حدود مستخدم+حساب</b>\n";
            $text .= "<code>/setuseraccountlimits [telegram_id] [slug] daily=X</code>\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setuseraccountlimits 123456789 vip-acc daily=3</code>\n";
            $text .= "⚠️ <b>ملاحظات:</b> الأولوية الأعلى - يتجاوز كل الحدود الأخرى\n\n";
            
            $text .= "💡 <b>ملاحظات عامة:</b>\n";
            $text .= "• NULL = بلا حد\n";
            $text .= "• 0 = محظور تماماً\n";
            $text .= "• الحدود تُطبق على طلبات التحقق\n";
            
        } elseif ($section === 'users') {
            $text = "👤 <b>إدارة اشتراكات الزبائن</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ معلومات زبون</b>\n";
            $text .= "<code>/userinfo [telegram_id]</code>\n";
            $text .= "📝 <b>الشرح:</b> عرض بيانات واشتراكات زبون\n";
            $text .= "📌 <b>مثال:</b>\n<code>/userinfo 123456789</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>👤 الزبون\n• TG: 123456789\n• الحسابات: VIP (دائم), Premium (25 يوم)</i>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ تحويل إلى مدى الحياة</b>\n";
            $text .= "<code>/setuseraccount_lifetime [telegram_id] [account_slug]</code>\n";
            $text .= "📝 <b>الشرح:</b> تحويل اشتراك زبون إلى دائم\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setuseraccount_lifetime 123456789 vip-acc</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>✅ تم تحويل الاشتراك إلى دائم!\n• الزبون: 123456789\n• الحساب: VIP</i>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ تحديد فترة مؤقتة</b>\n";
            $text .= "<code>/setuseraccount_period [telegram_id] [account_slug] [days]</code>\n";
            $text .= "📝 <b>الشرح:</b> تحويل اشتراك من دائم إلى مؤقت أو تمديد\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setuseraccount_period 123456789 vip-acc 30</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>✅ تم تحديث الاشتراك!\n• الفترة: 30 يوم\n• ينتهي: 2025-01-03</i>\n";
            $text .= "⚠️ <b>ملاحظات:</b> يحول الاشتراك الدائم إلى مؤقت\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>4️⃣ تعديل جميع الاشتراكات الدائمة</b>\n";
            $text .= "<code>/convert_lifetime_to_period [account_slug] [days]</code>\n";
            $text .= "📝 <b>الشرح:</b> تحويل جميع الاشتراكات الدائمة لحساب معين إلى مؤقتة\n";
            $text .= "📌 <b>مثال:</b>\n<code>/convert_lifetime_to_period vip-acc 30</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>✅ تم تحويل 45 اشتراك دائم إلى 30 يوم\n• الحساب: VIP</i>\n";
            $text .= "⚠️ <b>تحذير:</b> يؤثر على جميع الزبائن!\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>5️⃣ إزالة اشتراك زبون</b>\n";
            $text .= "<code>/removeuseraccount [telegram_id] [account_slug]</code>\n";
            $text .= "📝 <b>الشرح:</b> إزالة اشتراك زبون من حساب\n";
            $text .= "📌 <b>مثال:</b>\n<code>/removeuseraccount 123456789 vip-acc</code>\n";
            
        } elseif ($section === 'replies') {
            $text = "💬 <b>إدارة الردود</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ قائمة المفاتيح</b>\n";
            $text .= "<code>/listreplies</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ تعديل رد</b>\n";
            $text .= "<code>/setreply [KEY]</code>\n";
            $text .= "📌 <b>مثال:</b>\n<code>/setreply WELCOME</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ رد مخصص لموزع</b>\n";
            $text .= "<code>/setsuperdistreply [sd_id] [KEY]</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>4️⃣ اختبار رد</b>\n";
            $text .= "<code>/testreply [KEY]</code>\n";
            
        } elseif ($section === 'bans') {
            $text = "🚫 <b>الحظر</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>حظر مستخدم:</b>\n";
            $text .= "<code>/ban_user [telegram_id] [reason?]</code>\n";
            $text .= "<code>/unban_user [telegram_id]</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>حظر موزع:</b>\n";
            $text .= "<code>/ban_superdist [id] [reason?]</code>\n";
            $text .= "<code>/unban_superdist [id]</code>\n";
            
        } elseif ($section === 'reports') {
            $text = "📊 <b>التقارير</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ إحصائيات النظام</b>\n";
            $text .= "<code>/system_stats</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ إحصائيات موزع</b>\n";
            $text .= "<code>/superdist_stats [id]</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ سجل أكواد موزع</b>\n";
            $text .= "<code>/superdist_log [id] [page?]</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>4️⃣ معلومات مستخدم</b>\n";
            $text .= "<code>/user_info [telegram_id]</code>\n";
            
        } elseif ($section === 'broadcast') {
            $text = "📢 <b>البث</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ البث للجميع</b>\n";
            $text .= "<code>/broadcast_all</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ البث للزبائن</b>\n";
            $text .= "<code>/broadcast_users</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ البث للموزعين</b>\n";
            $text .= "<code>/broadcast_superdists</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>4️⃣ البث لزبائن موزع</b>\n";
            $text .= "<code>/broadcast_superdist_users [sd_id]</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>5️⃣ إعدادات البث</b>\n";
            $text .= "<code>/broadcast_settings</code>\n";
            $text .= "<code>/set_broadcast_setting [key] [value]</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>6️⃣ البثات المحظورة</b>\n";
            $text .= "<code>/blocked_broadcasts [limit?]</code>\n";
            
        } elseif ($section === 'vouchers') {
            $text = "🎟️ <b>نظام القسائم</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ إنشاء قسيمة موزع</b>\n";
            $text .= "<code>/create_voucher sd [account_ids] [days] [max_uses?]</code>\n";
            $text .= "📝 <b>الشرح:</b> قسيمة تضيف حسابات لموزع\n";
            $text .= "📌 <b>مثال:</b>\n<code>/create_voucher sd 1,2,3 30 1</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>تم إنشاء القسيمة!\n🎟️ الكود: VCH-A1B2-C3D4</i>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ إنشاء حزمة أكواد</b>\n";
            $text .= "<code>/create_voucher bundle [account_id] [codes_count] [type?] [days?]</code>\n";
            $text .= "📝 <b>الشرح:</b> قسيمة تولد أكواد تفعيل\n";
            $text .= "📌 <b>مثال:</b>\n<code>/create_voucher bundle 1 10 timed 30</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ معلومات قسيمة</b>\n";
            $text .= "<code>/voucher_info [code]</code>\n";
            $text .= "📌 <b>مثال:</b>\n<code>/voucher_info VCH-A1B2-C3D4</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>4️⃣ قائمة القسائم</b>\n";
            $text .= "<code>/list_vouchers [type?] [status?]</code>\n";
            $text .= "📌 <b>مثال:</b>\n<code>/list_vouchers sd unused</code>\n";
            $text .= "⚠️ <b>الحالات:</b> unused, partial, used, expired, disabled\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>5️⃣ تعطيل قسيمة</b>\n";
            $text .= "<code>/disable_voucher [code]</code>\n";
            
        } elseif ($section === 'system') {
            $text = "🔧 <b>فحص النظام</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ تشغيل فحص</b>\n";
            $text .= "<code>/run_system_check [full|quick]</code>\n";
            $text .= "📝 <b>الشرح:</b> فحص شامل للنظام\n";
            $text .= "📌 <b>مثال:</b>\n<code>/run_system_check full</code>\n";
            $text .= "✅ <b>النتيجة:</b>\n<i>تقرير فحص النظام\n✅ جميع الاختبارات نجحت\n⏱️ المدة: 245ms</i>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ قائمة التقارير</b>\n";
            $text .= "<code>/system_reports [limit?]</code>\n";
            $text .= "📌 <b>مثال:</b>\n<code>/system_reports 5</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ عرض تقرير</b>\n";
            $text .= "<code>/view_report [id]</code>\n";
            
        } elseif ($section === 'blacklist') {
            $text = "🚷 <b>القائمة السوداء للبث</b>\n\n";
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ إضافة كلمة</b>\n";
            $text .= "<code>/blacklist_add [word] [type?] [severity?]</code>\n";
            $text .= "📝 <b>الشرح:</b> إضافة كلمة ممنوعة\n";
            $text .= "📌 <b>مثال:</b>\n<code>/blacklist_add spam word block</code>\n";
            $text .= "⚠️ <b>الأنواع:</b> word, regex, domain\n";
            $text .= "⚠️ <b>الخطورة:</b> block, warn, log\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ حذف كلمة</b>\n";
            $text .= "<code>/blacklist_remove [id]</code>\n\n";
            
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ عرض القائمة</b>\n";
            $text .= "<code>/blacklist_list</code>\n";
            
        } elseif ($section === 'access') {
            $text = "🔑 <b>إدارة صلاحيات الوصول الدفعي</b>\n";
            $text .= "👥 <b>المتأثرون:</b> الزبائن (users) فقط - لا يؤثر على الموزعين\n\n";
            
            // ═══════════════════════════════════════════
            // الأمر 1: تغيير صلاحيات الزبائن
            // ═══════════════════════════════════════════
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>1️⃣ تغيير صلاحيات الزبائن دفعة</b>\n";
            $text .= "<code>/set_users_access [accounts] [type] [days?] [flags?]</code>\n\n";
            
            $text .= "👥 <b>من يتأثر:</b> جميع الزبائن المشتركين في الحسابات المحددة\n";
            $text .= "📝 <b>الشرح:</b> تغيير نوع اشتراك الزبائن من lifetime إلى timed أو العكس\n\n";
            
            $text .= "<b>المعاملات:</b>\n";
            $text .= "• <code>accounts</code>: معرف حساب أو أكثر (1,2,3) أو slug أو <code>all</code>\n";
            $text .= "• <code>type</code>: <code>lifetime</code> (مدى الحياة) أو <code>timed</code> (محدود)\n";
            $text .= "• <code>days</code>: عدد الأيام (مطلوب فقط مع timed)\n\n";
            
            $text .= "<b>Flags:</b>\n";
            $text .= "• <code>--preview</code>: معاينة التغييرات بدون تطبيقها\n";
            $text .= "• <code>--force</code>: تغيير اشتراكات lifetime أيضاً\n";
            $text .= "• <code>--notify</code>: إرسال إشعار للزبائن المتأثرين\n\n";
            
            $text .= "⚡ <b>سلوك استقطاع المدة:</b>\n";
            $text .= "عند التحويل لـ timed يُحسب من تاريخ التفعيل الأصلي:\n";
            $text .= "• زبون فعّل قبل 20 يوم → تغيير لـ 30 يوم = 10 أيام متبقية\n";
            $text .= "• زبون فعّل قبل 40 يوم → تغيير لـ 30 يوم = ❌ منتهي فوراً\n\n";
            
            $text .= "📌 <b>أمثلة عملية:</b>\n\n";
            
            $text .= "<b>مثال 1:</b> معاينة قبل التنفيذ\n";
            $text .= "<code>/set_users_access vip-acc timed 30 --preview</code>\n";
            $text .= "📤 <i>النتيجة: يعرض كم سيبقى لهم مدة وكم سينتهي فوراً</i>\n\n";
            
            $text .= "<b>مثال 2:</b> تحويل زبائن حساب لـ 30 يوم\n";
            $text .= "<code>/set_users_access vip-acc timed 30</code>\n";
            $text .= "📤 <i>النتيجة: يُستقطع الوقت المستهلك من الـ 30 يوم</i>\n\n";
            
            $text .= "<b>مثال 3:</b> تحويل الكل بما فيهم lifetime\n";
            $text .= "<code>/set_users_access 1,2 timed 60 --force</code>\n";
            $text .= "📤 <i>النتيجة: الكل يحصل على 60 يوم ناقص المستهلك</i>\n\n";
            
            $text .= "<b>مثال 4:</b> تحويل الكل لـ lifetime مع إشعار\n";
            $text .= "<code>/set_users_access all lifetime --force --notify</code>\n";
            $text .= "📤 <i>النتيجة: جميع الزبائن يصبحون lifetime + إشعار لهم</i>\n\n";
            
            // ═══════════════════════════════════════════
            // الأمر 2: ضبط الوصول الافتراضي
            // ═══════════════════════════════════════════
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>2️⃣ ضبط الوصول الافتراضي للحساب</b>\n";
            $text .= "<code>/set_default_account_access [account] [mode] [days?]</code>\n\n";
            
            $text .= "👥 <b>من يتأثر:</b> الزبائن الجدد فقط (عند تفعيل كود جديد)\n";
            $text .= "📝 <b>الشرح:</b> تحديد نوع الاشتراك للزبائن الجدد عند التفعيل\n\n";
            
            $text .= "<b>المعاملات:</b>\n";
            $text .= "• <code>account</code>: معرف أو slug الحساب أو <code>all</code>\n";
            $text .= "• <code>mode</code>:\n";
            $text .= "  - <code>inherit_global</code>: استخدام الإعداد العام\n";
            $text .= "  - <code>lifetime</code>: مدى الحياة دائماً\n";
            $text .= "  - <code>timed</code>: محدود بأيام معينة\n\n";
            
            $text .= "📌 <b>أمثلة عملية:</b>\n\n";
            
            $text .= "<b>مثال 1:</b> حساب VIP دائماً lifetime\n";
            $text .= "<code>/set_default_account_access vip-acc lifetime</code>\n";
            $text .= "📤 <i>النتيجة: أي زبون جديد يفعّل كود VIP = lifetime</i>\n\n";
            
            $text .= "<b>مثال 2:</b> حساب trial لـ 7 أيام\n";
            $text .= "<code>/set_default_account_access trial-acc timed 7</code>\n";
            $text .= "📤 <i>النتيجة: أي زبون جديد يفعّل كود Trial = 7 أيام</i>\n\n";
            
            $text .= "<b>مثال 3:</b> إرجاع الكل للإعداد العام\n";
            $text .= "<code>/set_default_account_access all inherit_global</code>\n";
            $text .= "📤 <i>النتيجة: جميع الحسابات تستخدم الإعداد العام</i>\n\n";
            
            // ═══════════════════════════════════════════
            // الأمر 3: عرض الوصول الافتراضي
            // ═══════════════════════════════════════════
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>3️⃣ عرض الوصول الافتراضي</b>\n";
            $text .= "<code>/get_default_account_access [account|all]</code>\n\n";
            
            $text .= "📝 <b>الشرح:</b> عرض إعدادات الوصول الافتراضي الحالية\n\n";
            
            $text .= "📌 <b>أمثلة:</b>\n";
            $text .= "<code>/get_default_account_access vip-acc</code>\n";
            $text .= "<code>/get_default_account_access all</code>\n\n";
            
            // ═══════════════════════════════════════════
            // الأمر 4: قائمة الحسابات
            // ═══════════════════════════════════════════
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "<b>4️⃣ قائمة الحسابات التي ترث الإعدادات</b>\n";
            $text .= "<code>/list_accounts_with_default_inherit</code>\n\n";
            
            $text .= "📝 <b>الشرح:</b> عرض الحسابات التي تستخدم الإعداد العام\n\n";
            
            // ═══════════════════════════════════════════
            // ملاحظات هامة
            // ═══════════════════════════════════════════
            $text .= "━━━━━━━━━━━━━━━━━━━━\n";
            $text .= "⚠️ <b>تحذيرات هامة:</b>\n";
            $text .= "• استخدم <code>--preview</code> أولاً دائماً!\n";
            $text .= "• بدون <code>--force</code>: لن يتأثر زبائن lifetime\n";
            $text .= "• <code>--notify</code>: يرسل رسالة لكل زبون متأثر\n\n";
            
            $text .= "📊 <b>جدول التأثير:</b>\n";
            $text .= "┌─────────────┬───────────────┐\n";
            $text .= "│ الأمر       │ من يتأثر      │\n";
            $text .= "├─────────────┼───────────────┤\n";
            $text .= "│ set_users   │ زبائن حاليين  │\n";
            $text .= "│ set_default │ زبائن جدد    │\n";
            $text .= "└─────────────┴───────────────┘\n";
            
        } else {
            $text = "❓ قسم غير معروف.\n\nاستخدم /help لعرض الأقسام المتاحة.";
        }
        
        Telegram::sendLongMessage($chatId, $text);
    }
    
    // ================================================================
    // إدارة الحسابات
    // ================================================================
    
    private static function cmdAddAccount(int $chatId, string $args): void
    {
        $parts = array_map('trim', explode('|', $args));
        if (count($parts) < 3) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/addaccount slug | name | secret_key</code>");
            return;
        }
        
        [$slug, $name, $secretKey] = $parts;
        
        if (getAccountBySlug($slug)) {
            Telegram::sendMessage($chatId, "❌ يوجد حساب بنفس الـ slug: {$slug}");
            return;
        }
        
        $id = Db::insert('accounts', ['slug' => $slug, 'name' => $name, 'secret_key' => $secretKey, 'status' => 'active']);
        Logger::event('account_created', 'admin', null, 'account', $id, ['slug' => $slug]);
        Telegram::sendMessage($chatId, "✅ تم إضافة الحساب!\n• ID: {$id}\n• Slug: {$slug}");
    }
    
    private static function cmdListAccounts(int $chatId): void
    {
        $accounts = Db::fetchAll("SELECT id, slug, name, status FROM accounts ORDER BY id");
        if (empty($accounts)) { Telegram::sendMessage($chatId, "📦 لا توجد حسابات."); return; }
        
        $text = "📦 <b>الحسابات</b> (" . count($accounts) . ")\n\n";
        foreach ($accounts as $acc) {
            $icon = $acc['status'] === 'active' ? '🟢' : '🔴';
            $text .= "{$icon} ID:{$acc['id']} | <code>{$acc['slug']}</code> | {$acc['name']}\n";
        }
        Telegram::sendLongMessage($chatId, $text);
    }
    
    private static function cmdAccountInfo(int $chatId, string $args): void
    {
        $args = trim($args);
        if ($args === '') { Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/accountinfo [id|slug]</code>"); return; }
        
        $account = is_numeric($args) ? getAccountById((int)$args) : getAccountBySlug($args);
        if (!$account) { Telegram::sendMessage($chatId, "❌ الحساب غير موجود."); return; }
        
        $totalCodes = Db::count('activation_codes', 'account_id = ?', [$account['id']]);
        $usedCodes = Db::count('activation_codes', 'account_id = ? AND status = ?', [$account['id'], 'used']);
        $linkedSuperDists = Db::count('superdist_accounts', 'account_id = ?', [$account['id']]);
        $linkedUsers = Db::count('user_accounts', 'account_id = ?', [$account['id']]);
        
        $text = "📦 <b>الحساب {$account['id']}</b>\n\n";
        $text .= "• Slug: <code>{$account['slug']}</code>\n";
        $text .= "• الاسم: {$account['name']}\n";
        $text .= "• الحالة: " . ($account['status'] === 'active' ? '🟢 نشط' : '🔴 معطل') . "\n";
        $text .= "• نوع الاشتراك الافتراضي: " . ($account['default_access_type'] ?? 'lifetime') . "\n";
        if (($account['default_access_type'] ?? '') === 'timed' && $account['default_access_days']) {
            $text .= "• الأيام الافتراضية: {$account['default_access_days']}\n";
        }
        $text .= "\n📊 <b>الإحصائيات:</b>\n";
        $text .= "• أكواد التفعيل: {$usedCodes}/{$totalCodes}\n";
        $text .= "• الموزعين المرتبطين: {$linkedSuperDists}\n";
        $text .= "• الزبائن المشتركين: {$linkedUsers}\n";
        
        // عرض حدود الحساب إن وجدت
        $accountLimits = Limits::getAccountLimits($account['id']);
        if ($accountLimits['daily'] !== null || $accountLimits['weekly'] !== null || $accountLimits['monthly'] !== null) {
            $text .= "\n⚙️ <b>حدود الحساب:</b>\n";
            if ($accountLimits['daily'] !== null) $text .= "• يومي: {$accountLimits['daily']}\n";
            if ($accountLimits['weekly'] !== null) $text .= "• أسبوعي: {$accountLimits['weekly']}\n";
            if ($accountLimits['monthly'] !== null) $text .= "• شهري: {$accountLimits['monthly']}\n";
        }
        
        Telegram::sendMessage($chatId, $text);
    }
    
    private static function cmdSetAccountKey(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args, 2);
        if (count($parts) < 2) { Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/setaccountkey [id] [key]</code>"); return; }
        
        $accountId = (int)$parts[0];
        $account = getAccountById($accountId);
        if (!$account) { Telegram::sendMessage($chatId, "❌ الحساب غير موجود."); return; }
        
        Db::update('accounts', ['secret_key' => $parts[1]], 'id = ?', [$accountId]);
        Telegram::sendMessage($chatId, "✅ تم تحديث المفتاح السري للحساب {$accountId}.");
    }
    
    /**
     * تعديل حساب
     * الصيغة: /editaccount [id|slug] name=<new_name> slug=<new_slug>
     */
    private static function cmdEditAccount(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args, 2);
        $identifier = $parts[0] ?? '';
        $updates = $parts[1] ?? '';
        
        if (empty($identifier) || empty($updates)) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/editaccount [id|slug] name=... slug=...</code>\n\nمثال:\n<code>/editaccount 3 name=حساب VIP الجديد slug=vip-new</code>");
            return;
        }
        
        // جلب الحساب
        $account = is_numeric($identifier) ? getAccountById((int)$identifier) : getAccountBySlug($identifier);
        if (!$account) {
            Telegram::sendMessage($chatId, "❌ الحساب غير موجود: {$identifier}");
            return;
        }
        
        // تحليل المعاملات
        $updateData = [];
        $changesText = [];
        
        // تحليل name=...
        if (preg_match('/name=([^\s]+(?:\s+[^\s=]+)*?)(?=\s+\w+=|$)/u', $updates, $m)) {
            $newName = trim($m[1]);
            if (!empty($newName)) {
                $updateData['name'] = $newName;
                $changesText[] = "الاسم: {$newName}";
            }
        }
        
        // تحليل slug=...
        if (preg_match('/slug=([a-zA-Z0-9_-]+)/', $updates, $m)) {
            $newSlug = strtolower(trim($m[1]));
            
            // التحقق من عدم تكرار الـ slug
            if ($newSlug !== $account['slug']) {
                $existing = getAccountBySlug($newSlug);
                if ($existing) {
                    Telegram::sendMessage($chatId, "❌ يوجد حساب آخر بنفس الـ slug: {$newSlug}");
                    return;
                }
                $updateData['slug'] = $newSlug;
                $changesText[] = "Slug: {$newSlug}";
            }
        }
        
        if (empty($updateData)) {
            Telegram::sendMessage($chatId, "❌ لم يتم تحديد أي تعديلات صالحة.");
            return;
        }
        
        // تنفيذ التحديث
        Db::update('accounts', $updateData, 'id = ?', [$account['id']]);
        
        Logger::event('account_updated', 'admin', null, 'account', $account['id'], $updateData);
        
        $text = "✅ تم تحديث الحساب {$account['id']}:\n\n";
        $text .= implode("\n", array_map(fn($c) => "• {$c}", $changesText));
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * حذف حساب (soft delete)
     * الصيغة: /deleteaccount [id|slug] confirm
     * أو خطوتين باستخدام State
     */
    private static function cmdDeleteAccount(int $chatId, string $args, int $fromId): void
    {
        $parts = preg_split('/\s+/', trim($args));
        $identifier = $parts[0] ?? '';
        $confirm = strtolower($parts[1] ?? '');
        
        if (empty($identifier)) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/deleteaccount [id|slug] confirm</code>\n\nمثال:\n<code>/deleteaccount 3 confirm</code>\n\n⚠️ لا يمكن حذف حساب له أكواد أو اشتراكات مرتبطة.");
            return;
        }
        
        // جلب الحساب
        $account = is_numeric($identifier) ? getAccountById((int)$identifier) : getAccountBySlug($identifier);
        if (!$account) {
            Telegram::sendMessage($chatId, "❌ الحساب غير موجود: {$identifier}");
            return;
        }
        
        // التحقق من الروابط
        $linkedCodes = Db::count('activation_codes', 'account_id = ?', [$account['id']]);
        $linkedUsers = Db::count('user_accounts', 'account_id = ?', [$account['id']]);
        $linkedSuperDists = Db::count('superdist_accounts', 'account_id = ?', [$account['id']]);
        
        if ($linkedCodes > 0 || $linkedUsers > 0 || $linkedSuperDists > 0) {
            $text = "❌ لا يمكن حذف الحساب {$account['id']} ({$account['slug']}) لوجود بيانات مرتبطة:\n\n";
            if ($linkedCodes > 0) $text .= "• أكواد تفعيل: {$linkedCodes}\n";
            if ($linkedUsers > 0) $text .= "• اشتراكات زبائن: {$linkedUsers}\n";
            if ($linkedSuperDists > 0) $text .= "• ربط موزعين: {$linkedSuperDists}\n";
            $text .= "\n💡 يمكنك تعطيل الحساب بدلاً من حذفه.";
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        // التحقق من التأكيد
        if ($confirm !== 'confirm' && $confirm !== 'تأكيد') {
            $text = "⚠️ <b>تحذير: حذف الحساب</b>\n\n";
            $text .= "أنت على وشك حذف الحساب:\n";
            $text .= "• ID: {$account['id']}\n";
            $text .= "• Slug: {$account['slug']}\n";
            $text .= "• الاسم: {$account['name']}\n\n";
            $text .= "لتأكيد الحذف، أرسل:\n<code>/deleteaccount {$account['id']} confirm</code>";
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        // تنفيذ الحذف
        Db::delete('accounts', 'id = ?', [$account['id']]);
        
        Logger::event('account_deleted', 'admin', null, 'account', $account['id'], [
            'slug' => $account['slug'],
            'name' => $account['name'],
        ]);
        
        Telegram::sendMessage($chatId, "✅ تم حذف الحساب {$account['id']} ({$account['slug']}) نهائياً.");
    }
    
    /**
     * ضبط حدود الحساب
     * الصيغة: /setaccountlimits [id|slug] daily=X weekly=Y monthly=Z
     */
    private static function cmdSetAccountLimits(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args, 2);
        $identifier = $parts[0] ?? '';
        $limitsStr = $parts[1] ?? '';
        
        if (empty($identifier) || empty($limitsStr)) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/setaccountlimits [id|slug] daily=X weekly=Y monthly=Z</code>\n\nمثال:\n<code>/setaccountlimits vip-acc daily=3 weekly=15 monthly=50</code>");
            return;
        }
        
        // جلب الحساب
        $account = is_numeric($identifier) ? getAccountById((int)$identifier) : getAccountBySlug($identifier);
        if (!$account) {
            Telegram::sendMessage($chatId, "❌ الحساب غير موجود: {$identifier}");
            return;
        }
        
        $limits = self::parseLimitsArgs($limitsStr);
        
        if (empty($limits)) {
            Telegram::sendMessage($chatId, "❌ يجب تحديد حد واحد على الأقل: daily=X أو weekly=Y أو monthly=Z");
            return;
        }
        
        // تطبيق الحدود
        Limits::setAccountLimits(
            $account['id'],
            $limits['daily'] ?? null,
            $limits['weekly'] ?? null,
            $limits['monthly'] ?? null
        );
        
        $text = "✅ تم تحديث حدود الحساب:\n\n";
        $text .= "• الحساب: {$account['slug']}\n";
        $text .= "• يومي: " . ($limits['daily'] ?? 'غير محدد') . "\n";
        $text .= "• أسبوعي: " . ($limits['weekly'] ?? 'غير محدد') . "\n";
        $text .= "• شهري: " . ($limits['monthly'] ?? 'غير محدد') . "\n";
        $text .= "\n⚠️ هذه الحدود تنطبق على جميع المستخدمين لهذا الحساب.";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    // ================================================================
    // إدارة السوبر موزعين
    // ================================================================
    
    private static function cmdAddSuperDist(int $chatId, string $args): void
    {
        $parts = array_map('trim', explode('|', $args));
        if (count($parts) < 2) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/addsuperdist telegram_id | display_name</code>");
            return;
        }
        
        $telegramId = (int)$parts[0];
        $displayName = $parts[1];
        
        if (getSuperDistByTelegramId($telegramId)) {
            Telegram::sendMessage($chatId, "❌ يوجد سوبر موزع بهذا المعرف مسبقاً.");
            return;
        }
        
        $id = Db::insert('super_distributors', [
            'telegram_id' => $telegramId, 'display_name' => $displayName,
            'status' => 'active', 'can_broadcast' => 1, 
            'broadcast_allowed_types' => '["text","stickers","photos","videos","documents","audio"]'
        ]);
        
        Logger::event('superdist_created', 'admin', null, 'superdist', $id);
        Telegram::sendMessage($chatId, "✅ تم إضافة السوبر موزع!\n• ID: {$id}\n• TG: {$telegramId}\n\n⚠️ استخدم /setsuperdistaccounts لربط الحسابات.");
    }
    
    private static function cmdListSuperDists(int $chatId, string $args): void
    {
        $statusFilter = strtolower(trim($args));
        $validStatuses = ['active', 'suspended', 'banned', 'archived'];
        
        // فلترة حسب الحالة إذا تم تحديدها
        if ($statusFilter && in_array($statusFilter, $validStatuses)) {
            $superdists = Db::fetchAll(
                "SELECT id, telegram_id, display_name, status FROM super_distributors WHERE status = ? ORDER BY id DESC",
                [$statusFilter]
            );
            $filterText = " ({$statusFilter})";
        } else {
            $superdists = Db::fetchAll("SELECT id, telegram_id, display_name, status FROM super_distributors ORDER BY id DESC");
            $filterText = "";
        }
        
        if (empty($superdists)) { 
            Telegram::sendMessage($chatId, "👥 لا يوجد سوبر موزعين" . ($statusFilter ? " بحالة: {$statusFilter}" : "") . "."); 
            return; 
        }
        
        $icons = ['active' => '🟢', 'suspended' => '🟡', 'banned' => '🔴', 'archived' => '📦'];
        $text = "👥 <b>السوبر موزعون{$filterText}</b> (" . count($superdists) . ")\n\n";
        foreach ($superdists as $sd) {
            $icon = $icons[$sd['status']] ?? '⚪';
            $text .= "{$icon} ID:{$sd['id']} | TG:{$sd['telegram_id']} | {$sd['display_name']}\n";
        }
        Telegram::sendLongMessage($chatId, $text);
    }
    
    private static function cmdSuperDistInfo(int $chatId, string $args): void
    {
        $id = (int)trim($args);
        if ($id <= 0) { Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/superdistinfo [id]</code>"); return; }
        
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$id]);
        if (!$sd) { Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود."); return; }
        
        $accounts = Db::fetchAll("SELECT sa.*, a.slug FROM superdist_accounts sa JOIN accounts a ON a.id = sa.account_id WHERE sa.superdist_id = ?", [$id]);
        $totalCodes = Db::count('activation_codes', 'superdist_id = ?', [$id]);
        
        $text = "👤 <b>السوبر موزع {$id}</b>\n\n";
        $text .= "• TG: {$sd['telegram_id']}\n• الاسم: {$sd['display_name']}\n• الحالة: {$sd['status']}\n• الأكواد: {$totalCodes}\n\n";
        $text .= "📦 <b>الحسابات:</b>\n";
        foreach ($accounts as $acc) {
            $active = strtotime($acc['end_at']) > time() ? '🟢' : '🔴';
            $text .= "{$active} {$acc['slug']} - " . formatRemainingDays($acc['end_at']) . "\n";
        }
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * تعديل بيانات موزع
     * الصيغة: /editsuperdist [id] [field]=[value]
     */
    private static function cmdEditSuperDist(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args, 2);
        if (count($parts) < 2) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/editsuperdist [id] [field]=[value]</code>\n\n📝 الحقول: name, telegram_id, status");
            return;
        }
        
        $id = (int)$parts[0];
        $fieldValue = $parts[1];
        
        // التحقق من وجود الموزع
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$id]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود.");
            return;
        }
        
        // استخراج الحقل والقيمة
        if (strpos($fieldValue, '=') === false) {
            Telegram::sendMessage($chatId, "❌ صيغة خاطئة. استخدم: field=value");
            return;
        }
        
        [$field, $value] = explode('=', $fieldValue, 2);
        $field = strtolower(trim($field));
        $value = trim($value);
        
        // الحقول المسموحة
        $allowedFields = [
            'name' => 'display_name',
            'display_name' => 'display_name',
            'telegram_id' => 'telegram_id',
            'status' => 'status',
        ];
        
        if (!isset($allowedFields[$field])) {
            Telegram::sendMessage($chatId, "❌ حقل غير مسموح: {$field}\n\n📝 الحقول المسموحة: name, telegram_id, status");
            return;
        }
        
        $dbField = $allowedFields[$field];
        
        // التحقق من القيم
        if ($dbField === 'status' && !in_array($value, ['active', 'suspended', 'banned', 'archived'])) {
            Telegram::sendMessage($chatId, "❌ حالة غير صالحة.\n\n📝 الحالات: active, suspended, banned, archived");
            return;
        }
        
        if ($dbField === 'telegram_id') {
            $value = (int)$value;
            if ($value <= 0) {
                Telegram::sendMessage($chatId, "❌ Telegram ID غير صالح.");
                return;
            }
            // التحقق من عدم التكرار
            $existing = Db::fetchOne("SELECT id FROM super_distributors WHERE telegram_id = ? AND id != ?", [$value, $id]);
            if ($existing) {
                Telegram::sendMessage($chatId, "❌ Telegram ID مستخدم من موزع آخر.");
                return;
            }
        }
        
        // تطبيق التعديل
        $oldValue = $sd[$dbField];
        Db::update('super_distributors', [$dbField => $value], 'id = ?', [$id]);
        
        Logger::event('superdist_edited', 'superdist', $id, 'admin', null, [
            'field' => $dbField,
            'old_value' => $oldValue,
            'new_value' => $value,
        ]);
        
        $text = "✅ <b>تم تعديل الموزع #{$id}</b>\n\n";
        $text .= "• <b>الحقل:</b> {$field}\n";
        $text .= "• <b>القيمة القديمة:</b> {$oldValue}\n";
        $text .= "• <b>القيمة الجديدة:</b> {$value}\n";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * حذف موزع نهائياً
     * الصيغة: /deletesuperdist [id] confirm
     */
    private static function cmdDeleteSuperDist(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        $id = (int)($parts[0] ?? 0);
        $confirm = strtolower($parts[1] ?? '');
        
        if ($id <= 0) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/deletesuperdist [id] confirm</code>");
            return;
        }
        
        // التحقق من وجود الموزع
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$id]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود.");
            return;
        }
        
        // إذا لم يكن هناك تأكيد، عرض تحذير
        if ($confirm !== 'confirm') {
            $codesCount = Db::count('activation_codes', 'superdist_id = ?', [$id]);
            $accountsCount = Db::count('superdist_accounts', 'superdist_id = ?', [$id]);
            
            $text = "⚠️ <b>تحذير: حذف الموزع #{$id}</b>\n\n";
            $text .= "👤 <b>الاسم:</b> {$sd['display_name']}\n";
            $text .= "📱 <b>TG:</b> {$sd['telegram_id']}\n";
            $text .= "📊 <b>الأكواد:</b> {$codesCount}\n";
            $text .= "📦 <b>الحسابات:</b> {$accountsCount}\n\n";
            $text .= "🗑️ <b>سيتم حذف:</b>\n";
            $text .= "• جميع أكواد التفعيل\n";
            $text .= "• جميع ربط الحسابات\n";
            $text .= "• سجلات البث\n\n";
            $text .= "❗ <b>هذا الإجراء لا يمكن التراجع عنه!</b>\n\n";
            $text .= "للتأكيد، أرسل:\n<code>/deletesuperdist {$id} confirm</code>";
            
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        // تنفيذ الحذف
        try {
            Db::beginTransaction();
            
            // حذف الأكواد
            $codesDeleted = Db::count('activation_codes', 'superdist_id = ?', [$id]);
            Db::execute("DELETE FROM activation_codes WHERE superdist_id = ?", [$id]);
            
            // حذف ربط الحسابات
            $accountsDeleted = Db::count('superdist_accounts', 'superdist_id = ?', [$id]);
            Db::execute("DELETE FROM superdist_accounts WHERE superdist_id = ?", [$id]);
            
            // حذف سجلات البث
            Db::execute("DELETE FROM broadcast_logs WHERE broadcaster_type = 'superdist' AND broadcaster_id = ?", [$id]);
            
            // حذف الموزع
            Db::execute("DELETE FROM super_distributors WHERE id = ?", [$id]);
            
            Db::commit();
            
            Logger::event('superdist_deleted', 'superdist', $id, 'admin', null, [
                'display_name' => $sd['display_name'],
                'telegram_id' => $sd['telegram_id'],
                'codes_deleted' => $codesDeleted,
                'accounts_deleted' => $accountsDeleted,
            ]);
            
            $text = "🗑️ <b>تم حذف الموزع #{$id} نهائياً</b>\n\n";
            $text .= "👤 <b>الاسم:</b> {$sd['display_name']}\n";
            $text .= "📊 <b>الأكواد المحذوفة:</b> {$codesDeleted}\n";
            $text .= "📦 <b>الحسابات:</b> {$accountsDeleted}\n";
            
            Telegram::sendMessage($chatId, $text);
            
        } catch (Throwable $e) {
            Db::rollback();
            Logger::error('Failed to delete superdist', ['id' => $id, 'error' => $e->getMessage()]);
            Telegram::sendMessage($chatId, "❌ فشل حذف الموزع: " . $e->getMessage());
        }
    }
    
    private static function cmdSetSuperDistAccounts(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        if (count($parts) < 3 || $parts[1] !== 'add') {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/setsuperdistaccounts [sd_id] add [account_ids]</code>");
            return;
        }
        
        $sdId = (int)$parts[0];
        $accIds = array_map('intval', explode(',', $parts[2]));
        
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$sdId]);
        if (!$sd) { Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود."); return; }
        
        $added = [];
        foreach ($accIds as $accId) {
            if (!getAccountById($accId)) continue;
            if (Db::exists('superdist_accounts', 'superdist_id = ? AND account_id = ?', [$sdId, $accId])) continue;
            
            $endAt = date('Y-m-d H:i:s', strtotime('+30 days'));
            Db::insert('superdist_accounts', ['superdist_id' => $sdId, 'account_id' => $accId, 'start_at' => date('Y-m-d H:i:s'), 'duration_days' => 30, 'end_at' => $endAt]);
            $added[] = $accId;
        }
        
        Telegram::sendMessage($chatId, "✅ تمت إضافة: " . implode(',', $added) . "\n\n⚠️ استخدم /setsuperdistaccountperiod لتعديل الفترة.");
    }
    
    private static function cmdSetSuperDistAccountPeriod(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        if (count($parts) < 3) { Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/setsuperdistaccountperiod [sd_id] [acc_id] [days]</code>"); return; }
        
        $sdId = (int)$parts[0]; $accId = (int)$parts[1]; $days = (int)$parts[2];
        
        $endAt = date('Y-m-d H:i:s', strtotime("+{$days} days"));
        Db::update('superdist_accounts', ['start_at' => date('Y-m-d H:i:s'), 'duration_days' => $days, 'end_at' => $endAt], 'superdist_id = ? AND account_id = ?', [$sdId, $accId]);
        Telegram::sendMessage($chatId, "✅ تم تحديث الفترة: {$days} يوم.");
    }
    
    private static function cmdSuspendSuperDist(int $chatId, string $args): void
    {
        $id = (int)trim($args);
        Db::update('super_distributors', ['status' => 'suspended'], 'id = ?', [$id]);
        Db::execute("UPDATE activation_codes SET status = 'disabled' WHERE superdist_id = ? AND status = 'unused'", [$id]);
        Telegram::sendMessage($chatId, "✅ تم إيقاف السوبر موزع {$id}.");
    }
    
    private static function cmdActivateSuperDist(int $chatId, string $args): void
    {
        $id = (int)trim($args);
        Db::update('super_distributors', ['status' => 'active'], 'id = ?', [$id]);
        Telegram::sendMessage($chatId, "✅ تم تفعيل السوبر موزع {$id}.");
    }
    
    /**
     * أرشفة سوبر موزع
     * الصيغة: /archivesuperdist [id] [reason?]
     * 
     * يُستخدم لإيقاف السوبر موزع نهائياً بدون حذف سجلاته.
     * - يُعطّل جميع أكواده غير المستخدمة
     * - لا يمكنه توليد أكواد أو البث
     * - تبقى تقاريره وأكواده القديمة محفوظة
     */
    private static function cmdArchiveSuperDist(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args, 2);
        $id = (int)($parts[0] ?? 0);
        $reason = $parts[1] ?? 'تم الأرشفة بواسطة الإدارة';
        
        if ($id <= 0) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/archivesuperdist [id] [reason?]</code>\n\nمثال:\n<code>/archivesuperdist 5 انتهاء العقد</code>");
            return;
        }
        
        // التحقق من وجود السوبر موزع
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$id]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود: {$id}");
            return;
        }
        
        // التحقق من عدم الأرشفة المسبقة
        if ($sd['status'] === 'archived') {
            Telegram::sendMessage($chatId, "⚠️ السوبر موزع مؤرشف مسبقاً.");
            return;
        }
        
        // أرشفة السوبر موزع
        Db::update('super_distributors', [
            'status'            => 'archived',
            'status_reason'     => $reason,
            'status_changed_at' => date('Y-m-d H:i:s'),
        ], 'id = ?', [$id]);
        
        // تعطيل الأكواد غير المستخدمة
        $disabledCodes = Db::execute(
            "UPDATE activation_codes SET status = 'disabled' WHERE superdist_id = ? AND status = 'unused'",
            [$id]
        );
        
        // تسجيل الحدث
        Logger::event('superdist_archived', 'admin', null, 'superdist', $id, [
            'reason' => $reason,
            'disabled_codes' => $disabledCodes,
        ]);
        
        $text = "✅ تم أرشفة السوبر موزع {$id} ({$sd['display_name']}).\n\n";
        $text .= "• السبب: {$reason}\n";
        $text .= "• الأكواد المعطّلة: {$disabledCodes}\n\n";
        $text .= "⚠️ لا يمكنه الآن توليد أكواد أو البث، لكن سجلاته محفوظة.";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    private static function cmdCreateSuperDistCode(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        if (count($parts) < 4) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/createsuperdistcode [type] [accounts] [days] [uses]</code>\n\nمثال: /createsuperdistcode new 1,2 30 1");
            return;
        }
        
        $type = $parts[0]; $accIds = array_map('intval', explode(',', $parts[1])); $days = (int)$parts[2]; $uses = (int)$parts[3];
        $code = CodeGenerator::generateSuperDistCode();
        
        $accountsData = array_map(fn($id) => ['account_id' => $id, 'duration_days' => $days], $accIds);
        Db::insert('superdist_subscription_codes', ['code' => $code, 'code_type' => $type, 'accounts_data' => json_encode($accountsData), 'max_uses' => $uses, 'status' => 'unused']);
        
        Telegram::sendMessage($chatId, "✅ الكود: <code>{$code}</code>\n• النوع: {$type}\n• الحسابات: " . implode(',', $accIds) . "\n• المدة: {$days} يوم");
    }
    
    private static function cmdCheckCode(int $chatId, string $args): void
    {
        $code = strtoupper(trim($args));
        $type = CodeGenerator::getCodeType($code);
        
        if ($type === 'superdist') {
            $row = Db::fetchOne("SELECT * FROM superdist_subscription_codes WHERE code = ?", [$code]);
            if ($row) Telegram::sendMessage($chatId, "🔍 كود سوبر موزع\n• الحالة: {$row['status']}\n• الاستخدامات: {$row['current_uses']}/{$row['max_uses']}");
            else Telegram::sendMessage($chatId, "❌ الكود غير موجود.");
        } elseif ($type === 'activation') {
            $row = Db::fetchOne("SELECT ac.*, a.slug FROM activation_codes ac JOIN accounts a ON a.id = ac.account_id WHERE ac.code = ?", [$code]);
            if ($row) Telegram::sendMessage($chatId, "🔍 كود تفعيل\n• الحساب: {$row['slug']}\n• الحالة: {$row['status']}");
            else Telegram::sendMessage($chatId, "❌ الكود غير موجود.");
        } else {
            Telegram::sendMessage($chatId, "❌ صيغة كود غير معروفة.");
        }
    }
    
    // ================================================================
    // إدارة الحدود
    // ================================================================
    
    private static function cmdSetGlobalLimits(int $chatId, string $args): void
    {
        $limits = self::parseLimitsArgs($args);
        if (empty($limits)) { Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/setgloballimits daily=2 weekly=10 monthly=30</code>"); return; }
        
        $current = Limits::getGlobalLimits();
        Limits::setGlobalLimits($limits['daily'] ?? $current['daily'], $limits['weekly'] ?? $current['weekly'], $limits['monthly'] ?? $current['monthly']);
        Telegram::sendMessage($chatId, "✅ تم تحديث الحدود العامة.");
    }
    
    private static function cmdSetSuperDistLimits(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args, 2);
        if (count($parts) < 2) { Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/setsuperdistlimits [sd_id] daily=X</code>"); return; }
        
        $sdId = (int)$parts[0]; $limits = self::parseLimitsArgs($parts[1]);
        Limits::setSuperDistLimits($sdId, $limits['daily'] ?? null, $limits['weekly'] ?? null, $limits['monthly'] ?? null);
        Telegram::sendMessage($chatId, "✅ تم تحديث حدود السوبر موزع {$sdId}.");
    }
    
    private static function cmdSetUserLimits(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args, 2);
        if (count($parts) < 2) { Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/setuserlimits [telegram_id] daily=X</code>"); return; }
        
        $user = getUserByTelegramId((int)$parts[0]);
        if (!$user) { Telegram::sendMessage($chatId, "❌ المستخدم غير موجود."); return; }
        
        $limits = self::parseLimitsArgs($parts[1]);
        Limits::setUserLimits($user['id'], $limits['daily'] ?? null, $limits['weekly'] ?? null, $limits['monthly'] ?? null);
        Telegram::sendMessage($chatId, "✅ تم تحديث حدود المستخدم.");
    }
    
    // ================================================================
    // إدارة الردود
    // ================================================================
    
    private static function cmdListReplies(int $chatId): void
    {
        $replies = Replies::listKeys();
        $text = "💬 <b>مفاتيح الردود</b>\n\n";
        foreach ($replies as $r) { $text .= "• <code>{$r['key']}</code>\n"; }
        Telegram::sendLongMessage($chatId, $text);
    }
    
    private static function cmdSetReply(int $chatId, string $args, int $fromId): void
    {
        $key = strtoupper(trim($args));
        if ($key === '') { Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/setreply [KEY]</code>"); return; }
        
        State::set($fromId, 'admin', State::STATE_AWAITING_REPLY_TEXT, ['reply_key' => $key]);
        Telegram::sendMessage($chatId, "📝 أرسل النص الجديد للرد: {$key}\n\nأو /cancel للإلغاء.");
    }
    
    private static function cmdTestReply(int $chatId, string $args): void
    {
        $key = strtoupper(trim($args));
        $result = Replies::testReply($key);
        $text = "🔍 <b>اختبار الرد:</b> {$key}\n\n{$result['text']}";
        Telegram::sendMessage($chatId, $text);
    }
    
    // ================================================================
    // الحظر
    // ================================================================
    
    private static function cmdBanUser(int $chatId, string $args, int $fromId): void
    {
        $parts = preg_split('/\s+/', $args, 2);
        $telegramId = (int)$parts[0]; $reason = $parts[1] ?? '';
        
        $user = getUserByTelegramId($telegramId);
        if (!$user) { Telegram::sendMessage($chatId, "❌ المستخدم غير موجود."); return; }
        
        Db::update('users', ['status' => 'banned', 'ban_reason' => $reason, 'banned_at' => date('Y-m-d H:i:s')], 'id = ?', [$user['id']]);
        Db::insert('bans', ['target_type' => 'user', 'target_id' => $user['id'], 'target_telegram_id' => $telegramId, 'reason' => $reason, 'banned_by' => 'admin']);
        Logger::userBanned($user['id'], $reason, 'admin');
        Telegram::sendMessage($chatId, "✅ تم حظر المستخدم {$telegramId}.");
    }
    
    private static function cmdUnbanUser(int $chatId, string $args, int $fromId): void
    {
        $telegramId = (int)trim($args);
        $user = getUserByTelegramId($telegramId);
        if (!$user) { Telegram::sendMessage($chatId, "❌ المستخدم غير موجود."); return; }
        
        Db::update('users', ['status' => 'active', 'ban_reason' => null, 'banned_at' => null], 'id = ?', [$user['id']]);
        Db::update('bans', ['is_active' => 0, 'unbanned_at' => date('Y-m-d H:i:s')], 'target_type = ? AND target_id = ? AND is_active = 1', ['user', $user['id']]);
        Logger::userUnbanned($user['id'], 'admin');
        Telegram::sendMessage($chatId, "✅ تم فك حظر المستخدم {$telegramId}.");
    }
    
    private static function cmdBanSuperDist(int $chatId, string $args, int $fromId): void
    {
        $parts = preg_split('/\s+/', $args, 2);
        $sdId = (int)$parts[0]; $reason = $parts[1] ?? '';
        
        Db::update('super_distributors', ['status' => 'banned', 'status_reason' => $reason], 'id = ?', [$sdId]);
        Db::execute("UPDATE activation_codes SET status = 'disabled' WHERE superdist_id = ? AND status = 'unused'", [$sdId]);
        Telegram::sendMessage($chatId, "✅ تم حظر السوبر موزع {$sdId}.");
    }
    
    // ================================================================
    // التقارير
    // ================================================================
    
    private static function cmdSystemStats(int $chatId): void
    {
        $stats = [
            'accounts' => Db::count('accounts', '1=1'),
            'superdists' => Db::count('super_distributors', '1=1'),
            'users' => Db::count('users', '1=1'),
            'act_codes' => Db::count('activation_codes', '1=1'),
            'verifications_today' => Db::count('verification_logs', 'DATE(requested_at) = CURDATE()'),
        ];
        
        $text = "📊 <b>إحصائيات النظام</b>\n\n";
        $text .= "• الحسابات: {$stats['accounts']}\n";
        $text .= "• السوبر موزعون: {$stats['superdists']}\n";
        $text .= "• الزبائن: {$stats['users']}\n";
        $text .= "• أكواد التفعيل: {$stats['act_codes']}\n";
        $text .= "• طلبات التحقق اليوم: {$stats['verifications_today']}\n";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    private static function cmdSuperDistStats(int $chatId, string $args): void
    {
        $id = (int)trim($args);
        if ($id <= 0) { Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/superdist_stats [id]</code>"); return; }
        
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$id]);
        if (!$sd) { Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود."); return; }
        
        $totalCodes = Db::count('activation_codes', 'superdist_id = ?', [$id]);
        $usedCodes = Db::count('activation_codes', 'superdist_id = ? AND status = ?', [$id, 'used']);
        $todayCodes = Db::count('activation_codes', 'superdist_id = ? AND DATE(created_at) = CURDATE()', [$id]);
        
        $text = "📊 <b>إحصائيات السوبر موزع {$id}</b>\n\n";
        $text .= "• الاسم: {$sd['display_name']}\n";
        $text .= "• إجمالي الأكواد: {$totalCodes}\n";
        $text .= "• المستخدمة: {$usedCodes}\n";
        $text .= "• اليوم: {$todayCodes}\n";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    // ================================================================
    // البث
    // ================================================================
    
    private static function cmdBroadcast(int $chatId, int $fromId, string $audienceType, string $filter = ''): void
    {
        State::startBroadcast($fromId, 'admin', $audienceType, $filter ?: null);
        Telegram::sendMessage($chatId, Replies::get('INFO_BROADCAST_AWAITING_CONTENT'));
    }
    
    public static function getBroadcastRecipientsCount(array $data): int
    {
        $type = $data['audience_type'] ?? 'all';
        switch ($type) {
            case 'all': return Db::count('users', '1=1') + Db::count('super_distributors', '1=1');
            case 'users': return Db::count('users', 'status = ?', ['active']);
            case 'superdists': return Db::count('super_distributors', 'status = ?', ['active']);
            case 'superdist_users':
                $sdId = (int)($data['audience_filter'] ?? 0);
                return Db::count('user_accounts', 'superdist_id = ?', [$sdId]);
            default: return 0;
        }
    }
    
    public static function executeBroadcast(int $fromId, int $chatId): void
    {
        $data = State::getBroadcastData($fromId);
        if (!$data) { 
            Telegram::sendMessage($chatId, "❌ لا توجد بيانات بث."); 
            return; 
        }
        
        State::clear($fromId);
        Telegram::sendMessage($chatId, Replies::get('INFO_BROADCAST_STARTED'));
        
        // ⚠️ مهم: استخدام توكن البوت العام للبث
        // لأن المستخدمين تفاعلوا مع البوت العام وليس بوت الإدارة
        $publicToken = config('PUBLIC_BOT_TOKEN');
        if ($publicToken) {
            Telegram::setToken($publicToken);
        }
        
        $recipients = self::getBroadcastRecipients($data);
        $success = 0; 
        $failed = 0;
        $errors = [];
        
        // تحديد المحتوى الصحيح
        $contentType = $data['content_type'] ?? 'text';
        $content = '';
        
        if ($contentType === 'text') {
            $content = $data['content_text'] ?? '';
        } else {
            $content = $data['content_file_id'] ?? '';
        }
        
        $caption = $data['content_caption'] ?? '';
        
        // التحقق من وجود محتوى
        if (empty($content)) {
            Telegram::sendMessage($chatId, "❌ المحتوى فارغ! لا يمكن البث.");
            Logger::error('Broadcast failed: empty content', [
                'from_id' => $fromId,
                'content_type' => $contentType,
                'data' => $data,
            ]);
            return;
        }
        
        foreach ($recipients as $r) {
            $telegramId = $r['telegram_id'] ?? null;
            
            if (!$telegramId) {
                $failed++;
                continue;
            }
            
            $result = Telegram::sendByType($telegramId, $contentType, $content, $caption);
            
            if ($result['ok'] ?? false) {
                $success++;
            } else {
                $failed++;
                $errorDesc = $result['description'] ?? ($result['error'] ?? 'Unknown error');
                
                // تسجيل الخطأ (أول 5 أخطاء فقط للتفاصيل)
                if (count($errors) < 5) {
                    $errors[] = [
                        'telegram_id' => $telegramId,
                        'error_code'  => $result['error_code'] ?? 0,
                        'description' => $errorDesc,
                    ];
                }
                
                // التحقق من خطأ file_id - إيقاف البث إذا كان الخطأ متعلق بالملف
                if (strpos($errorDesc, 'wrong file identifier') !== false || 
                    strpos($errorDesc, 'file not found') !== false) {
                    // إعادة التوكن لبوت الإدارة
                    $adminToken = config('ADMIN_BOT_TOKEN');
                    if ($adminToken) {
                        Telegram::setToken($adminToken);
                    }
                    
                    $errorText = "❌ <b>فشل البث - خطأ في الملف!</b>\n\n";
                    $errorText .= "⚠️ <b>السبب:</b>\n";
                    $errorText .= "الملف المرسل من بوت الإدارة غير صالح للبوت العام.\n\n";
                    $errorText .= "💡 <b>الحل:</b>\n";
                    $errorText .= "1️⃣ للبث للزبائن: أرسل الملف من البوت العام\n";
                    $errorText .= "2️⃣ للبث للموزعين فقط: استخدم /broadcast_superdists\n";
                    $errorText .= "3️⃣ أو أرسل <b>نص فقط</b> بدلاً من ملف\n\n";
                    $errorText .= "📊 نجح: {$success} | فشل: {$failed}";
                    
                    Telegram::sendMessage($chatId, $errorText);
                    Logger::error('Broadcast aborted: file_id not valid for public bot', [
                        'from_id' => $fromId,
                        'content_type' => $contentType,
                    ]);
                    return;
                }
                
                // تسجيل في اللوج
                Logger::error('Broadcast send failed', [
                    'telegram_id' => $telegramId,
                    'content_type'=> $contentType,
                    'error_code'  => $result['error_code'] ?? 0,
                    'description' => $errorDesc,
                ]);
            }
            
            usleep(50000); // 50ms بين كل إرسال
        }
        
        // إعادة التوكن لبوت الإدارة
        $adminToken = config('ADMIN_BOT_TOKEN');
        if ($adminToken) {
            Telegram::setToken($adminToken);
        }
        
        // إرسال النتيجة
        $resultText = Replies::get('INFO_BROADCAST_DONE', [
            'success' => $success, 
            'failed'  => $failed, 
            'total'   => count($recipients)
        ]);
        
        // إضافة تفاصيل الأخطاء إن وجدت
        if (!empty($errors)) {
            $resultText .= "\n\n⚠️ <b>عينة من الأخطاء:</b>\n";
            foreach ($errors as $err) {
                // تحسين رسالة الخطأ
                $desc = $err['description'];
                if (strpos($desc, 'blocked') !== false) {
                    $desc = 'المستخدم حظر البوت';
                } elseif (strpos($desc, 'not found') !== false || strpos($desc, 'deactivated') !== false) {
                    $desc = 'الحساب محذوف أو معطل';
                }
                $resultText .= "• TG:{$err['telegram_id']} → {$desc}\n";
            }
        }
        
        Telegram::sendMessage($chatId, $resultText);
        
        // تسجيل البث في قاعدة البيانات
        Db::insert('broadcast_logs', [
            'broadcaster_type' => 'admin',
            'broadcaster_id'   => (string)$fromId,
            'audience_type'    => $data['audience_type'] ?? 'all',
            'audience_filter'  => $data['audience_filter'] ?? null,
            'content_type'     => $contentType,
            'content_text'     => $data['content_text'] ?? null,
            'content_file_id'  => $data['content_file_id'] ?? null,
            'content_caption'  => $data['content_caption'] ?? null,
            'total_recipients' => count($recipients),
            'successful_sends' => $success,
            'failed_sends'     => $failed,
            'errors'           => !empty($errors) ? json_encode($errors, JSON_UNESCAPED_UNICODE) : null,
            'status'           => 'completed',
            'started_at'       => date('Y-m-d H:i:s'),
            'completed_at'     => date('Y-m-d H:i:s'),
        ]);
        
        Logger::broadcastCompleted('admin', (string)$fromId, $data['audience_type'], count($recipients), $success, $failed);
    }
    
    private static function getBroadcastRecipients(array $data): array
    {
        $type = $data['audience_type'] ?? 'all';
        switch ($type) {
            case 'all':
                $users = Db::fetchAll("SELECT telegram_id FROM users WHERE status = 'active'");
                $sds = Db::fetchAll("SELECT telegram_id FROM super_distributors WHERE status = 'active'");
                return array_merge($users, $sds);
            case 'users': return Db::fetchAll("SELECT telegram_id FROM users WHERE status = 'active'");
            case 'superdists': return Db::fetchAll("SELECT telegram_id FROM super_distributors WHERE status = 'active'");
            case 'superdist_users':
                $sdId = (int)($data['audience_filter'] ?? 0);
                return Db::fetchAll("SELECT DISTINCT u.telegram_id FROM users u JOIN user_accounts ua ON ua.user_id = u.id WHERE ua.superdist_id = ? AND u.status = 'active'", [$sdId]);
            default: return [];
        }
    }
    
    public static function handlePendingInput(string $text, int $fromId, int $chatId, array $state): bool
    {
        return false;
    }
    
    // ================================================================
    // الأوامر الإضافية (1-6)
    // ================================================================
    
    /**
     * 1. ضبط حدود User + Account (أعلى طبقة)
     * الصيغة: /setuseraccountlimits <telegram_id> <account_slug> daily=X weekly=Y monthly=Z
     */
    private static function cmdSetUserAccountLimits(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args, 3);
        
        if (count($parts) < 3) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/setuseraccountlimits [telegram_id] [account_slug] daily=X weekly=Y monthly=Z</code>\n\nمثال:\n<code>/setuseraccountlimits 123456789 vip-acc daily=5 weekly=20</code>");
            return;
        }
        
        $telegramId = (int) $parts[0];
        $accountSlug = $parts[1];
        $limitsStr = $parts[2];
        
        // التحقق من المستخدم
        $user = getUserByTelegramId($telegramId);
        if (!$user) {
            Telegram::sendMessage($chatId, "❌ المستخدم غير موجود: {$telegramId}");
            return;
        }
        
        // التحقق من الحساب
        $account = getAccountBySlug($accountSlug);
        if (!$account) {
            Telegram::sendMessage($chatId, "❌ الحساب غير موجود: {$accountSlug}");
            return;
        }
        
        $limits = self::parseLimitsArgs($limitsStr);
        
        if (empty($limits)) {
            Telegram::sendMessage($chatId, "❌ يجب تحديد حد واحد على الأقل: daily=X أو weekly=Y أو monthly=Z");
            return;
        }
        
        // تطبيق الحدود
        Limits::setUserAccountLimits(
            $user['id'],
            $account['id'],
            $limits['daily'] ?? null,
            $limits['weekly'] ?? null,
            $limits['monthly'] ?? null
        );
        
        $text = "✅ تم تحديث حدود المستخدم+الحساب:\n\n";
        $text .= "• المستخدم: {$telegramId}\n";
        $text .= "• الحساب: {$accountSlug}\n";
        $text .= "• يومي: " . ($limits['daily'] ?? 'غير محدد') . "\n";
        $text .= "• أسبوعي: " . ($limits['weekly'] ?? 'غير محدد') . "\n";
        $text .= "• شهري: " . ($limits['monthly'] ?? 'غير محدد') . "\n";
        $text .= "\n⚠️ هذه الطبقة لها الأولوية الأعلى (تتجاوز حدود المستخدم والسوبر موزع والعام).";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * 2أ. جعل اشتراك زبون مدى الحياة
     * الصيغة: /setuseraccount_lifetime <telegram_id> <account_slug>
     */
    private static function cmdSetUserAccountLifetime(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        
        if (count($parts) < 2) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/setuseraccount_lifetime [telegram_id] [account_slug]</code>");
            return;
        }
        
        $telegramId = (int) $parts[0];
        $accountSlug = $parts[1];
        
        $user = getUserByTelegramId($telegramId);
        if (!$user) {
            Telegram::sendMessage($chatId, "❌ المستخدم غير موجود.");
            return;
        }
        
        $account = getAccountBySlug($accountSlug);
        if (!$account) {
            Telegram::sendMessage($chatId, "❌ الحساب غير موجود.");
            return;
        }
        
        // التحقق من وجود الاشتراك
        $ua = Db::fetchOne(
            "SELECT * FROM user_accounts WHERE user_id = ? AND account_id = ?",
            [$user['id'], $account['id']]
        );
        
        if (!$ua) {
            Telegram::sendMessage($chatId, "❌ لا يوجد اشتراك لهذا المستخدم على هذا الحساب.\n\nيجب أن يفعّل المستخدم كوداً أولاً.");
            return;
        }
        
        // تحديث الاشتراك إلى مدى الحياة
        Db::update('user_accounts', [
            'access_type'       => 'lifetime',
            'access_expires_at' => null,
            'status'            => 'active',
        ], 'user_id = ? AND account_id = ?', [$user['id'], $account['id']]);
        
        Logger::event('user_account_updated', 'admin', null, 'user_account', $ua['id'], [
            'user_id'     => $user['id'],
            'account_id'  => $account['id'],
            'new_type'    => 'lifetime',
        ]);
        
        Telegram::sendMessage($chatId, "✅ تم تحويل اشتراك المستخدم {$telegramId} على الحساب {$accountSlug} إلى <b>مدى الحياة</b>.");
    }
    
    /**
     * 2ب. جعل اشتراك زبون مؤقتاً
     * الصيغة: /setuseraccount_period <telegram_id> <account_slug> <days>
     */
    private static function cmdSetUserAccountPeriod(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        
        if (count($parts) < 3) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/setuseraccount_period [telegram_id] [account_slug] [days]</code>");
            return;
        }
        
        $telegramId = (int) $parts[0];
        $accountSlug = $parts[1];
        $days = (int) $parts[2];
        
        if ($days <= 0) {
            Telegram::sendMessage($chatId, "❌ عدد الأيام يجب أن يكون أكبر من صفر.");
            return;
        }
        
        $user = getUserByTelegramId($telegramId);
        if (!$user) {
            Telegram::sendMessage($chatId, "❌ المستخدم غير موجود.");
            return;
        }
        
        $account = getAccountBySlug($accountSlug);
        if (!$account) {
            Telegram::sendMessage($chatId, "❌ الحساب غير موجود.");
            return;
        }
        
        $ua = Db::fetchOne(
            "SELECT * FROM user_accounts WHERE user_id = ? AND account_id = ?",
            [$user['id'], $account['id']]
        );
        
        if (!$ua) {
            Telegram::sendMessage($chatId, "❌ لا يوجد اشتراك لهذا المستخدم على هذا الحساب.");
            return;
        }
        
        $expiresAt = date('Y-m-d H:i:s', strtotime("+{$days} days"));
        
        Db::update('user_accounts', [
            'access_type'       => 'timed',
            'access_expires_at' => $expiresAt,
            'status'            => 'active',
        ], 'user_id = ? AND account_id = ?', [$user['id'], $account['id']]);
        
        Logger::event('user_account_updated', 'admin', null, 'user_account', $ua['id'], [
            'user_id'     => $user['id'],
            'account_id'  => $account['id'],
            'new_type'    => 'timed',
            'days'        => $days,
        ]);
        
        Telegram::sendMessage($chatId, "✅ تم تعيين اشتراك المستخدم {$telegramId} على الحساب {$accountSlug}:\n\n• النوع: مؤقت\n• المدة: {$days} يوم\n• ينتهي: " . formatDate($expiresAt));
    }
    
    /**
     * عرض معلومات زبون
     * الصيغة: /userinfo [telegram_id]
     */
    private static function cmdUserInfo(int $chatId, string $args): void
    {
        $telegramId = (int)trim($args);
        if ($telegramId <= 0) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/userinfo [telegram_id]</code>");
            return;
        }
        
        $user = getUserByTelegramId($telegramId);
        if (!$user) {
            Telegram::sendMessage($chatId, "❌ المستخدم غير موجود.");
            return;
        }
        
        // جلب الاشتراكات
        $accounts = Db::fetchAll(
            "SELECT ua.*, a.name, a.slug 
             FROM user_accounts ua 
             JOIN accounts a ON a.id = ua.account_id 
             WHERE ua.user_id = ?",
            [$user['id']]
        );
        
        $text = "👤 <b>معلومات الزبون</b>\n\n";
        $text .= "• <b>ID:</b> {$user['id']}\n";
        $text .= "• <b>TG:</b> {$telegramId}\n";
        $text .= "• <b>Username:</b> @" . ($user['username'] ?? 'لا يوجد') . "\n";
        $text .= "• <b>الاسم:</b> {$user['first_name']} " . ($user['last_name'] ?? '') . "\n";
        $text .= "• <b>الحالة:</b> {$user['status']}\n\n";
        
        $accountsCount = count($accounts);
        $text .= "📦 <b>الاشتراكات ({$accountsCount}):</b>\n";
        
        if (empty($accounts)) {
            $text .= "لا توجد اشتراكات.\n";
        } else {
            foreach ($accounts as $acc) {
                $accessType = $acc['access_type'] ?? 'timed';
                if ($accessType === 'lifetime') {
                    $statusIcon = '♾️';
                    $remaining = 'دائم';
                } else {
                    $expiresAt = $acc['access_expires_at'] ?? null;
                    if ($expiresAt && strtotime($expiresAt) > time()) {
                        $statusIcon = '🟢';
                        $remaining = formatRemainingDays($expiresAt);
                    } else {
                        $statusIcon = '🔴';
                        $remaining = 'منتهي';
                    }
                }
                $text .= "{$statusIcon} <b>{$acc['name']}</b> ({$acc['slug']})\n";
                $text .= "   └ {$remaining}\n";
            }
        }
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * تحويل جميع الاشتراكات الدائمة لحساب معين إلى مؤقتة
     * الصيغة: /convert_lifetime_to_period [account_slug] [days]
     */
    private static function cmdConvertLifetimeToPeriod(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        
        if (count($parts) < 2) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/convert_lifetime_to_period [account_slug] [days]</code>\n\n📌 مثال:\n<code>/convert_lifetime_to_period vip-acc 30</code>");
            return;
        }
        
        $accountSlug = $parts[0];
        $days = (int)$parts[1];
        
        if ($days <= 0) {
            Telegram::sendMessage($chatId, "❌ عدد الأيام يجب أن يكون أكبر من صفر.");
            return;
        }
        
        $account = getAccountBySlug($accountSlug);
        if (!$account) {
            Telegram::sendMessage($chatId, "❌ الحساب غير موجود: {$accountSlug}");
            return;
        }
        
        // حساب عدد الاشتراكات الدائمة
        $lifetimeCount = Db::fetchValue(
            "SELECT COUNT(*) FROM user_accounts WHERE account_id = ? AND access_type = 'lifetime'",
            [$account['id']]
        );
        
        if ($lifetimeCount == 0) {
            Telegram::sendMessage($chatId, "ℹ️ لا توجد اشتراكات دائمة على هذا الحساب.");
            return;
        }
        
        // طلب تأكيد إذا كان العدد كبيراً
        if ($lifetimeCount > 10 && strpos($args, 'confirm') === false) {
            $text = "⚠️ <b>تحذير!</b>\n\n";
            $text .= "سيتم تحويل <b>{$lifetimeCount}</b> اشتراك دائم إلى {$days} يوم.\n\n";
            $text .= "للتأكيد، أرسل:\n<code>/convert_lifetime_to_period {$accountSlug} {$days} confirm</code>";
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        // تنفيذ التحويل
        $expiresAt = date('Y-m-d H:i:s', strtotime("+{$days} days"));
        
        $affected = Db::execute(
            "UPDATE user_accounts 
             SET access_type = 'timed', 
                 access_expires_at = ? 
             WHERE account_id = ? AND access_type = 'lifetime'",
            [$expiresAt, $account['id']]
        );
        
        Logger::event('bulk_lifetime_converted', 'admin', null, 'account', $account['id'], [
            'days' => $days,
            'affected' => $lifetimeCount,
        ]);
        
        $text = "✅ <b>تم التحويل بنجاح!</b>\n\n";
        $text .= "• <b>الحساب:</b> {$account['name']}\n";
        $text .= "• <b>الاشتراكات المحولة:</b> {$lifetimeCount}\n";
        $text .= "• <b>الفترة الجديدة:</b> {$days} يوم\n";
        $text .= "• <b>ينتهي في:</b> " . formatDate($expiresAt);
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * إزالة اشتراك زبون
     * الصيغة: /removeuseraccount [telegram_id] [account_slug]
     */
    private static function cmdRemoveUserAccount(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        
        if (count($parts) < 2) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/removeuseraccount [telegram_id] [account_slug]</code>");
            return;
        }
        
        $telegramId = (int)$parts[0];
        $accountSlug = $parts[1];
        
        $user = getUserByTelegramId($telegramId);
        if (!$user) {
            Telegram::sendMessage($chatId, "❌ المستخدم غير موجود.");
            return;
        }
        
        $account = getAccountBySlug($accountSlug);
        if (!$account) {
            Telegram::sendMessage($chatId, "❌ الحساب غير موجود.");
            return;
        }
        
        $ua = Db::fetchOne(
            "SELECT * FROM user_accounts WHERE user_id = ? AND account_id = ?",
            [$user['id'], $account['id']]
        );
        
        if (!$ua) {
            Telegram::sendMessage($chatId, "❌ لا يوجد اشتراك لهذا المستخدم على هذا الحساب.");
            return;
        }
        
        // حذف الاشتراك
        Db::execute(
            "DELETE FROM user_accounts WHERE user_id = ? AND account_id = ?",
            [$user['id'], $account['id']]
        );
        
        Logger::event('user_account_removed', 'admin', null, 'user_account', $ua['id'], [
            'user_id' => $user['id'],
            'account_id' => $account['id'],
        ]);
        
        Telegram::sendMessage($chatId, "✅ تم إزالة اشتراك المستخدم {$telegramId} من الحساب {$accountSlug}.");
    }
    
    /**
     * 3. ضبط رد مخصص لسوبر موزع
     * الصيغة: /setsuperdistreply <superdist_id> <KEY>
     */
    private static function cmdSetSuperDistReply(int $chatId, string $args, int $fromId): void
    {
        $parts = preg_split('/\s+/', $args);
        
        if (count($parts) < 2) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/setsuperdistreply [superdist_id] [KEY]</code>\n\nمثال:\n<code>/setsuperdistreply 5 WELCOME_USER</code>");
            return;
        }
        
        $superdistId = (int) $parts[0];
        $key = strtoupper($parts[1]);
        
        // التحقق من السوبر موزع
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$superdistId]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود: {$superdistId}");
            return;
        }
        
        // التحقق من وجود المفتاح
        $exists = Db::exists('replies', '`key` = ?', [$key]);
        if (!$exists) {
            Telegram::sendMessage($chatId, "❌ المفتاح غير موجود: {$key}\n\nاستخدم /listreplies لعرض المفاتيح المتاحة.");
            return;
        }
        
        // تعيين حالة انتظار النص
        State::set($fromId, 'admin', State::STATE_AWAITING_SUPERDIST_REPLY_TEXT, [
            'superdist_id' => $superdistId,
            'reply_key'    => $key,
        ]);
        
        // جلب الرد الحالي للعرض
        $currentReply = Replies::testReply($key, $superdistId);
        $typeText = $currentReply['is_custom'] ? '(مخصص حالياً)' : '(افتراضي)';
        
        Telegram::sendMessage($chatId, "📝 <b>تعديل رد للسوبر موزع {$superdistId}</b>\n\nالمفتاح: {$key} {$typeText}\n\nالنص الحالي:\n<code>" . htmlspecialchars(substr($currentReply['text'], 0, 200)) . "</code>\n\n➡️ أرسل النص الجديد.\nأو /cancel للإلغاء.");
    }
    
    /**
     * 4. فك حظر السوبر موزع
     * الصيغة: /unban_superdist <superdist_id>
     */
    private static function cmdUnbanSuperDist(int $chatId, string $args, int $fromId): void
    {
        $superdistId = (int) trim($args);
        
        if ($superdistId <= 0) {
            Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/unban_superdist [superdist_id]</code>");
            return;
        }
        
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$superdistId]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود: {$superdistId}");
            return;
        }
        
        if ($sd['status'] !== 'banned') {
            Telegram::sendMessage($chatId, "⚠️ السوبر موزع ليس محظوراً. حالته الحالية: {$sd['status']}");
            return;
        }
        
        // إعادة تفعيل السوبر موزع
        Db::update('super_distributors', [
            'status'            => 'active',
            'status_reason'     => null,
            'status_changed_at' => date('Y-m-d H:i:s'),
        ], 'id = ?', [$superdistId]);
        
        // إغلاق سجل الحظر
        Db::update('bans', [
            'is_active'   => 0,
            'unbanned_at' => date('Y-m-d H:i:s'),
            'unbanned_by' => 'admin',
        ], 'target_type = ? AND target_id = ? AND is_active = 1', ['superdist', $superdistId]);
        
        Logger::event('superdist_unbanned', 'admin', null, 'superdist', $superdistId);
        
        Telegram::sendMessage($chatId, "✅ تم فك حظر السوبر موزع {$superdistId} ({$sd['display_name']}).\n\n• الحالة الجديدة: نشط\n\n⚠️ أكواده المعطّلة لا تزال معطّلة. استخدم /activatesuperdist إذا أردت تفعيل الأكواد.");
    }
    
    /**
     * 5. سجل أكواد السوبر موزع
     * الصيغة: /superdist_log <superdist_id> [page]
     */
    private static function cmdSuperDistLog(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        
        $superdistId = (int) ($parts[0] ?? 0);
        $page = max(1, (int) ($parts[1] ?? 1));
        $perPage = 15;
        $offset = ($page - 1) * $perPage;
        
        if ($superdistId <= 0) {
            Telegram::sendMessage($chatId, "❌ الاستخدام:\n<code>/superdist_log [superdist_id] [page?]</code>\n\nمثال:\n<code>/superdist_log 5</code>\n<code>/superdist_log 5 2</code>");
            return;
        }
        
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$superdistId]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود.");
            return;
        }
        
        // عدد الأكواد الكلي
        $totalCodes = Db::count('activation_codes', 'superdist_id = ?', [$superdistId]);
        $totalPages = max(1, ceil($totalCodes / $perPage));
        
        if ($totalCodes === 0) {
            Telegram::sendMessage($chatId, "📋 <b>سجل أكواد السوبر موزع {$superdistId}</b>\n\nلا توجد أكواد.");
            return;
        }
        
        // جلب الأكواد مع الحسابات والمستخدمين
        $codes = Db::fetchAll(
            "SELECT ac.*, a.slug as account_slug, a.name as account_name,
                    u.telegram_id as user_telegram_id
             FROM activation_codes ac
             JOIN accounts a ON a.id = ac.account_id
             LEFT JOIN users u ON u.id = ac.used_by_user_id
             WHERE ac.superdist_id = ?
             ORDER BY ac.created_at DESC
             LIMIT ? OFFSET ?",
            [$superdistId, $perPage, $offset]
        );
        
        $statusIcons = [
            'unused'   => '⚪',
            'used'     => '🟢',
            'expired'  => '🔴',
            'disabled' => '⛔',
        ];
        
        $text = "📋 <b>سجل أكواد السوبر موزع {$superdistId}</b>\n";
        $text .= "({$sd['display_name']})\n\n";
        $text .= "📊 الإجمالي: {$totalCodes} | الصفحة: {$page}/{$totalPages}\n\n";
        
        foreach ($codes as $code) {
            $icon = $statusIcons[$code['status']] ?? '❓';
            $text .= "{$icon} <code>{$code['code']}</code>\n";
            $text .= "   📦 {$code['account_slug']}\n";
            $text .= "   📅 " . formatDate($code['created_at']) . "\n";
            
            if ($code['status'] === 'used' && $code['user_telegram_id']) {
                $text .= "   👤 TG:{$code['user_telegram_id']} @ " . formatDate($code['used_at']) . "\n";
            }
            
            $text .= "\n";
        }
        
        // أزرار التنقل
        if ($totalPages > 1) {
            $text .= "─────────────────\n";
            if ($page > 1) {
                $text .= "⬅️ /superdist_log {$superdistId} " . ($page - 1) . "\n";
            }
            if ($page < $totalPages) {
                $text .= "➡️ /superdist_log {$superdistId} " . ($page + 1) . "\n";
            }
        }
        
        Telegram::sendLongMessage($chatId, $text);
    }
    
    /**
     * 6. ضبط صلاحيات البث للسوبر موزع
     * الصيغة: /setsuperdistbroadcast <superdist_id> <on|off> [content_types]
     * 
     * الأنواع المتاحة: text, stickers, photos, videos, documents, audio
     */
    private static function cmdSetSuperDistBroadcast(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', $args);
        
        if (count($parts) < 2) {
            $text = "❌ <b>ضبط صلاحيات البث للسوبر موزع</b>\n\n";
            $text .= "<b>الاستخدام:</b>\n";
            $text .= "<code>/setsuperdistbroadcast [id] [on|off] [types?]</code>\n\n";
            $text .= "<b>أنواع المحتوى المتاحة:</b>\n";
            $text .= "• text - نص\n";
            $text .= "• stickers - ملصقات\n";
            $text .= "• photos - صور\n";
            $text .= "• videos - فيديو\n";
            $text .= "• documents - مستندات\n";
            $text .= "• audio - صوت\n\n";
            $text .= "<b>أمثلة:</b>\n";
            $text .= "<code>/setsuperdistbroadcast 5 on text,stickers,photos</code>\n";
            $text .= "<code>/setsuperdistbroadcast 5 off</code>\n";
            $text .= "<code>/setsuperdistbroadcast 5 on all</code>";
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        $superdistId = (int) $parts[0];
        $toggle = strtolower($parts[1]);
        $typesArg = $parts[2] ?? null;
        
        if (!in_array($toggle, ['on', 'off'])) {
            Telegram::sendMessage($chatId, "❌ القيمة الثانية يجب أن تكون: on أو off");
            return;
        }
        
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$superdistId]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود: {$superdistId}");
            return;
        }
        
        $canBroadcast = ($toggle === 'on');
        
        // تحديد الأنواع المسموحة
        $allowedTypes = [];
        if ($canBroadcast && $typesArg) {
            if ($typesArg === 'all') {
                $allowedTypes = BroadcastFilter::CONTENT_TYPES;
            } else {
                $allowedTypes = array_map('trim', explode(',', $typesArg));
                // التحقق من صحة الأنواع
                $validTypes = array_intersect($allowedTypes, BroadcastFilter::CONTENT_TYPES);
                if (empty($validTypes)) {
                    Telegram::sendMessage($chatId, "❌ لا توجد أنواع صالحة.\n\nالأنواع المتاحة: " . implode(', ', BroadcastFilter::CONTENT_TYPES));
                    return;
                }
                $allowedTypes = $validTypes;
            }
        }
        
        // التحديث
        BroadcastFilter::setSuperdistBroadcastPermissions($superdistId, $canBroadcast, $allowedTypes);
        
        $statusText = $canBroadcast ? '✅ مسموح' : '❌ ممنوع';
        
        $text = "✅ تم تحديث صلاحيات البث للسوبر موزع #{$superdistId}:\n\n";
        $text .= "• البث: {$statusText}\n";
        
        if ($canBroadcast && !empty($allowedTypes)) {
            $text .= "• الأنواع المسموحة: " . implode(', ', $allowedTypes) . "\n";
        } elseif ($canBroadcast) {
            $text .= "• الأنواع المسموحة: جميع الأنواع\n";
        }
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * عرض صلاحيات البث لسوبر موزع
     * الصيغة: /superdist_broadcast_allowed [sd_id]
     */
    private static function cmdSuperDistBroadcastAllowed(int $chatId, string $args): void
    {
        $superdistId = (int) trim($args);
        
        if ($superdistId <= 0) {
            Telegram::sendMessage($chatId, "❌ <b>الاستخدام:</b>\n<code>/superdist_broadcast_allowed [sd_id]</code>\n\n<b>مثال:</b>\n<code>/superdist_broadcast_allowed 5</code>");
            return;
        }
        
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$superdistId]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود: {$superdistId}");
            return;
        }
        
        // استخدام helper function من SuperDistributorCommands
        require_once __DIR__ . '/../public/SuperDistributorCommands.php';
        $allowedTypesEn = SuperDistributorCommands::getBroadcastTypesEnglish($sd);
        $allowedTypesAr = SuperDistributorCommands::getHumanReadableBroadcastTypes($sd);
        
        $canBroadcast = $sd['can_broadcast'] ? 'YES ✅' : 'NO ❌';
        $lastUpdated = $sd['updated_at'] ?? $sd['created_at'] ?? 'N/A';
        
        $text = "📡 <b>صلاحيات البث للسوبر موزع</b>\n\n";
        $text .= "• <b>ID:</b> {$superdistId}\n";
        $text .= "• <b>الاسم:</b> {$sd['display_name']}\n";
        $text .= "• <b>can_broadcast:</b> {$canBroadcast}\n";
        $text .= "• <b>Allowed types:</b> {$allowedTypesEn}\n";
        $text .= "• <b>المحتوى المسموح:</b> {$allowedTypesAr}\n";
        $text .= "• <b>آخر تحديث:</b> {$lastUpdated}\n\n";
        $text .= "💡 <b>لتعديل الصلاحيات:</b>\n";
        $text .= "<code>/setsuperdistbroadcast {$superdistId} on text,photos</code>";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * عرض سجلات البث لسوبر موزع
     * الصيغة: /superdist_broadcast_logs [sd_id] [page?]
     */
    private static function cmdSuperDistBroadcastLogs(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', trim($args));
        $superdistId = (int) ($parts[0] ?? 0);
        $page = max(1, (int) ($parts[1] ?? 1));
        $perPage = 10;
        
        if ($superdistId <= 0) {
            Telegram::sendMessage($chatId, "❌ <b>الاستخدام:</b>\n<code>/superdist_broadcast_logs [sd_id] [page?]</code>\n\n<b>مثال:</b>\n<code>/superdist_broadcast_logs 5</code>\n<code>/superdist_broadcast_logs 5 2</code>");
            return;
        }
        
        $sd = Db::fetchOne("SELECT id, display_name FROM super_distributors WHERE id = ?", [$superdistId]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود: {$superdistId}");
            return;
        }
        
        // إجمالي السجلات
        $totalLogs = Db::fetchValue(
            "SELECT COUNT(*) FROM broadcast_logs WHERE broadcaster_type = 'superdist' AND broadcaster_id = ?",
            [(string)$superdistId]
        );
        
        if ($totalLogs == 0) {
            Telegram::sendMessage($chatId, "📭 لا توجد سجلات بث للسوبر موزع #{$superdistId} ({$sd['display_name']})");
            return;
        }
        
        $totalPages = max(1, ceil($totalLogs / $perPage));
        $offset = ($page - 1) * $perPage;
        
        // جلب السجلات
        $logs = Db::fetchAll(
            "SELECT id, started_at, content_type, total_recipients, successful_sends, failed_sends, status, errors
             FROM broadcast_logs 
             WHERE broadcaster_type = 'superdist' AND broadcaster_id = ?
             ORDER BY started_at DESC
             LIMIT ? OFFSET ?",
            [(string)$superdistId, $perPage, $offset]
        );
        
        $text = "📡 <b>سجلات البث - {$sd['display_name']}</b>\n";
        $text .= "📊 الإجمالي: {$totalLogs} | الصفحة {$page}/{$totalPages}\n\n";
        
        foreach ($logs as $log) {
            $errorsCount = 0;
            if ($log['errors']) {
                $errorsArr = json_decode($log['errors'], true);
                $errorsCount = is_array($errorsArr) ? count($errorsArr) : 0;
            }
            
            $statusIcon = match($log['status']) {
                'completed' => '✅',
                'in_progress' => '⏳',
                'cancelled' => '❌',
                default => '⚪'
            };
            
            $date = date('Y-m-d H:i', strtotime($log['started_at']));
            
            $text .= "<b>[#{$log['id']}]</b> {$date}\n";
            $text .= "   {$statusIcon} {$log['content_type']} | 👥 {$log['total_recipients']} | ✅ {$log['successful_sends']} | ❌ {$log['failed_sends']}";
            if ($errorsCount > 0) {
                $text .= " | ⚠️ {$errorsCount} errors";
            }
            $text .= "\n\n";
        }
        
        // التنقل بين الصفحات
        if ($totalPages > 1) {
            $text .= "─────────────────\n";
            if ($page > 1) {
                $text .= "⬅️ <code>/superdist_broadcast_logs {$superdistId} " . ($page - 1) . "</code>\n";
            }
            if ($page < $totalPages) {
                $text .= "➡️ <code>/superdist_broadcast_logs {$superdistId} " . ($page + 1) . "</code>\n";
            }
        }
        
        $text .= "\n💡 لعرض تفاصيل سجل:\n<code>/broadcast_log_view [log_id]</code>";
        
        Telegram::sendLongMessage($chatId, $text);
    }
    
    /**
     * عرض تفاصيل سجل بث
     * الصيغة: /broadcast_log_view [log_id]
     */
    private static function cmdBroadcastLogView(int $chatId, string $args): void
    {
        $logId = (int) trim($args);
        
        if ($logId <= 0) {
            Telegram::sendMessage($chatId, "❌ <b>الاستخدام:</b>\n<code>/broadcast_log_view [log_id]</code>\n\n<b>مثال:</b>\n<code>/broadcast_log_view 1023</code>");
            return;
        }
        
        $log = Db::fetchOne("SELECT * FROM broadcast_logs WHERE id = ?", [$logId]);
        if (!$log) {
            Telegram::sendMessage($chatId, "❌ سجل البث غير موجود: #{$logId}");
            return;
        }
        
        // جلب معلومات المُرسل
        $broadcasterName = "Unknown";
        if ($log['broadcaster_type'] === 'superdist') {
            $sd = Db::fetchOne("SELECT display_name FROM super_distributors WHERE id = ?", [(int)$log['broadcaster_id']]);
            $broadcasterName = $sd ? $sd['display_name'] : "SD#{$log['broadcaster_id']}";
        } else {
            $broadcasterName = "Admin #{$log['broadcaster_id']}";
        }
        
        $statusIcon = match($log['status']) {
            'completed' => '✅ مكتمل',
            'in_progress' => '⏳ جاري',
            'cancelled' => '❌ ملغي',
            default => '⚪ ' . $log['status']
        };
        
        $text = "📡 <b>تفاصيل سجل البث #{$logId}</b>\n\n";
        $text .= "• <b>المُرسل:</b> {$broadcasterName} ({$log['broadcaster_type']})\n";
        $text .= "• <b>الجمهور:</b> {$log['audience_type']}\n";
        $text .= "• <b>نوع المحتوى:</b> {$log['content_type']}\n";
        $text .= "• <b>الحالة:</b> {$statusIcon}\n\n";
        
        $text .= "📊 <b>الإحصائيات:</b>\n";
        $text .= "• المستهدفون: {$log['total_recipients']}\n";
        $text .= "• نجح: {$log['successful_sends']} ✅\n";
        $text .= "• فشل: {$log['failed_sends']} ❌\n\n";
        
        $text .= "🕐 <b>التوقيت:</b>\n";
        $text .= "• البدء: {$log['started_at']}\n";
        $text .= "• الانتهاء: " . ($log['completed_at'] ?? 'N/A') . "\n\n";
        
        // عرض المحتوى (مقتطف)
        if ($log['content_text']) {
            $snippet = mb_substr($log['content_text'], 0, 200);
            if (mb_strlen($log['content_text']) > 200) $snippet .= '...';
            $text .= "📝 <b>المحتوى:</b>\n<code>" . htmlspecialchars($snippet) . "</code>\n\n";
        }
        
        if ($log['content_file_id']) {
            $text .= "📎 <b>File ID:</b>\n<code>" . substr($log['content_file_id'], 0, 50) . "...</code>\n\n";
        }
        
        // عرض الأخطاء
        if ($log['errors']) {
            $errors = json_decode($log['errors'], true);
            if (is_array($errors) && !empty($errors)) {
                $text .= "⚠️ <b>الأخطاء ({$log['failed_sends']}):</b>\n";
                foreach (array_slice($errors, 0, 5) as $err) {
                    $desc = $err['description'] ?? 'Unknown';
                    if (strpos($desc, 'blocked') !== false) $desc = 'User blocked bot';
                    elseif (strpos($desc, 'deactivated') !== false) $desc = 'Account deactivated';
                    $text .= "• TG:{$err['telegram_id']} → {$desc}\n";
                }
                if (count($errors) > 5) {
                    $text .= "• ... و " . (count($errors) - 5) . " أخطاء أخرى\n";
                }
            }
        }
        
        Telegram::sendLongMessage($chatId, $text);
    }
    
    /**
     * معلومات بث شاملة للموزع
     * الصيغة: /superdist_broadcast_info [sd_id]
     */
    private static function cmdSuperDistBroadcastInfo(int $chatId, string $args): void
    {
        $superdistId = (int) trim($args);
        
        if ($superdistId <= 0) {
            Telegram::sendMessage($chatId, "❌ <b>الاستخدام:</b>\n<code>/superdist_broadcast_info [sd_id]</code>");
            return;
        }
        
        $sd = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [$superdistId]);
        if (!$sd) {
            Telegram::sendMessage($chatId, "❌ السوبر موزع غير موجود: {$superdistId}");
            return;
        }
        
        // الحصول على معلومات البث
        require_once __DIR__ . '/../public/SuperDistributorCommands.php';
        $allowedTypesAr = SuperDistributorCommands::getHumanReadableBroadcastTypes($sd);
        $allowedTypesEn = SuperDistributorCommands::getBroadcastTypesEnglish($sd);
        
        // إحصائيات البث
        $totalBroadcasts = Db::fetchValue(
            "SELECT COUNT(*) FROM broadcast_logs WHERE broadcaster_type = 'superdist' AND broadcaster_id = ?",
            [(string)$superdistId]
        );
        
        $lastBroadcast = Db::fetchOne(
            "SELECT started_at, status, content_type, successful_sends, failed_sends 
             FROM broadcast_logs 
             WHERE broadcaster_type = 'superdist' AND broadcaster_id = ?
             ORDER BY started_at DESC LIMIT 1",
            [(string)$superdistId]
        );
        
        $lastError = Db::fetchOne(
            "SELECT started_at, errors FROM broadcast_logs 
             WHERE broadcaster_type = 'superdist' AND broadcaster_id = ? AND errors IS NOT NULL AND errors != '[]'
             ORDER BY started_at DESC LIMIT 1",
            [(string)$superdistId]
        );
        
        $monthlyStats = Db::fetchOne(
            "SELECT COUNT(*) as total, SUM(successful_sends) as success, SUM(failed_sends) as failed
             FROM broadcast_logs 
             WHERE broadcaster_type = 'superdist' AND broadcaster_id = ?
             AND started_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)",
            [(string)$superdistId]
        );
        
        $canBroadcast = $sd['can_broadcast'] ? '✅ مسموح' : '❌ ممنوع';
        
        $text = "📡 <b>معلومات البث - {$sd['display_name']}</b>\n\n";
        $text .= "━━━━━━━━━━━━━━━━━━━━\n";
        $text .= "📊 <b>الحالة:</b>\n";
        $text .= "• البث: {$canBroadcast}\n";
        $text .= "• المحتوى المسموح: {$allowedTypesAr}\n";
        $text .= "• (English): {$allowedTypesEn}\n\n";
        
        $text .= "━━━━━━━━━━━━━━━━━━━━\n";
        $text .= "📈 <b>الإحصائيات:</b>\n";
        $text .= "• إجمالي البثات: {$totalBroadcasts}\n";
        $text .= "• بثات آخر 30 يوم: " . ($monthlyStats['total'] ?? 0) . "\n";
        $text .= "• رسائل ناجحة (شهر): " . ($monthlyStats['success'] ?? 0) . "\n";
        $text .= "• رسائل فاشلة (شهر): " . ($monthlyStats['failed'] ?? 0) . "\n\n";
        
        $text .= "━━━━━━━━━━━━━━━━━━━━\n";
        $text .= "🕐 <b>آخر بث:</b>\n";
        if ($lastBroadcast) {
            $statusIcon = $lastBroadcast['status'] === 'completed' ? '✅' : '❌';
            $text .= "• التاريخ: {$lastBroadcast['started_at']}\n";
            $text .= "• النوع: {$lastBroadcast['content_type']}\n";
            $text .= "• الحالة: {$statusIcon} {$lastBroadcast['status']}\n";
            $text .= "• نجح: {$lastBroadcast['successful_sends']} | فشل: {$lastBroadcast['failed_sends']}\n\n";
        } else {
            $text .= "• لا يوجد بث سابق\n\n";
        }
        
        $text .= "━━━━━━━━━━━━━━━━━━━━\n";
        $text .= "⚠️ <b>آخر خطأ:</b>\n";
        if ($lastError && $lastError['errors']) {
            $errors = json_decode($lastError['errors'], true);
            $firstError = $errors[0] ?? null;
            if ($firstError) {
                $text .= "• التاريخ: {$lastError['started_at']}\n";
                $text .= "• الوصف: " . ($firstError['description'] ?? 'Unknown') . "\n";
            }
        } else {
            $text .= "• لا توجد أخطاء مسجلة\n";
        }
        
        $text .= "\n💡 <b>أوامر ذات صلة:</b>\n";
        $text .= "<code>/superdist_broadcast_logs {$superdistId}</code>\n";
        $text .= "<code>/setsuperdistbroadcast {$superdistId} on text,photos</code>";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    // ================================================================
    // التصدير (Export)
    // ================================================================
    
    /**
     * تصدير السجلات
     * الصيغة: /export_logs [type] [days?]
     * الأنواع: activations, broadcasts, errors, system
     */
    private static function cmdExportLogs(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', trim($args));
        $type = strtolower($parts[0] ?? '');
        $days = (int)($parts[1] ?? 7);
        
        $validTypes = ['activations', 'broadcasts', 'errors', 'system', 'all'];
        
        if (empty($type) || !in_array($type, $validTypes)) {
            $text = "📤 <b>تصدير السجلات</b>\n\n";
            $text .= "<b>الاستخدام:</b>\n<code>/export_logs [type] [days?]</code>\n\n";
            $text .= "<b>الأنواع المتاحة:</b>\n";
            $text .= "• activations - سجلات التفعيل\n";
            $text .= "• broadcasts - سجلات البث\n";
            $text .= "• errors - سجلات الأخطاء\n";
            $text .= "• system - سجلات النظام\n";
            $text .= "• all - جميع السجلات\n\n";
            $text .= "<b>أمثلة:</b>\n";
            $text .= "<code>/export_logs activations 30</code>\n";
            $text .= "<code>/export_logs broadcasts 7</code>";
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        if ($days <= 0 || $days > 365) $days = 7;
        
        Telegram::sendMessage($chatId, "⏳ جاري تصدير سجلات {$type} لآخر {$days} أيام...");
        
        try {
            $content = "";
            $filename = "logs_{$type}_" . date('Ymd_His');
            $dateFrom = date('Y-m-d', strtotime("-{$days} days"));
            
            switch ($type) {
                case 'activations':
                    $logs = Db::fetchAll(
                        "SELECT ac.code, a.name as account_name, a.slug, 
                                u.telegram_id, ac.activated_at, ac.status
                         FROM activation_codes ac
                         JOIN accounts a ON ac.account_id = a.id
                         LEFT JOIN users u ON ac.used_by_user_id = u.id
                         WHERE ac.activated_at >= ?
                         ORDER BY ac.activated_at DESC",
                        [$dateFrom]
                    );
                    $content = "Code,Account,Slug,Telegram ID,Activated At,Status\n";
                    foreach ($logs as $log) {
                        $content .= "{$log['code']},{$log['account_name']},{$log['slug']},{$log['telegram_id']},{$log['activated_at']},{$log['status']}\n";
                    }
                    $filename .= ".csv";
                    break;
                    
                case 'broadcasts':
                    $logs = Db::fetchAll(
                        "SELECT id, broadcaster_type, broadcaster_id, audience_type, content_type,
                                total_recipients, successful_sends, failed_sends, status, started_at
                         FROM broadcast_logs
                         WHERE started_at >= ?
                         ORDER BY started_at DESC",
                        [$dateFrom]
                    );
                    $content = "ID,Broadcaster Type,Broadcaster ID,Audience,Content Type,Recipients,Success,Failed,Status,Started At\n";
                    foreach ($logs as $log) {
                        $content .= "{$log['id']},{$log['broadcaster_type']},{$log['broadcaster_id']},{$log['audience_type']},{$log['content_type']},{$log['total_recipients']},{$log['successful_sends']},{$log['failed_sends']},{$log['status']},{$log['started_at']}\n";
                    }
                    $filename .= ".csv";
                    break;
                    
                case 'errors':
                    $logs = Db::fetchAll(
                        "SELECT created_at, level, message, context
                         FROM system_logs
                         WHERE level IN ('error', 'critical') AND created_at >= ?
                         ORDER BY created_at DESC
                         LIMIT 1000",
                        [$dateFrom]
                    );
                    $content = "=== Error Logs ({$dateFrom} to now) ===\n\n";
                    foreach ($logs as $log) {
                        $content .= "[{$log['created_at']}] [{$log['level']}] {$log['message']}\n";
                        if ($log['context']) {
                            $content .= "Context: {$log['context']}\n";
                        }
                        $content .= "---\n";
                    }
                    $filename .= ".txt";
                    break;
                    
                case 'system':
                    $logs = Db::fetchAll(
                        "SELECT created_at, level, message
                         FROM system_logs
                         WHERE created_at >= ?
                         ORDER BY created_at DESC
                         LIMIT 2000",
                        [$dateFrom]
                    );
                    $content = "=== System Logs ({$dateFrom} to now) ===\n\n";
                    foreach ($logs as $log) {
                        $content .= "[{$log['created_at']}] [{$log['level']}] {$log['message']}\n";
                    }
                    $filename .= ".txt";
                    break;
                    
                case 'all':
                    // تصدير ملخص
                    $content = "=== All Logs Summary ({$dateFrom} to now) ===\n\n";
                    
                    $activations = Db::fetchValue("SELECT COUNT(*) FROM activation_codes WHERE activated_at >= ?", [$dateFrom]);
                    $broadcasts = Db::fetchValue("SELECT COUNT(*) FROM broadcast_logs WHERE started_at >= ?", [$dateFrom]);
                    $errors = Db::fetchValue("SELECT COUNT(*) FROM system_logs WHERE level = 'error' AND created_at >= ?", [$dateFrom]);
                    
                    $content .= "Activations: {$activations}\n";
                    $content .= "Broadcasts: {$broadcasts}\n";
                    $content .= "Errors: {$errors}\n";
                    $filename .= ".txt";
                    break;
            }
            
            if (empty($content) || strlen($content) < 50) {
                Telegram::sendMessage($chatId, "📭 لا توجد سجلات لهذه الفترة.");
                return;
            }
            
            // حفظ وإرسال الملف
            $filepath = config('TEMP_PATH') . $filename;
            file_put_contents($filepath, $content);
            
            $recordCount = substr_count($content, "\n");
            Telegram::sendDocument($chatId, $filepath, "✅ تم التصدير: {$recordCount} سجل", $filename);
            
            unlink($filepath);
            
        } catch (Throwable $e) {
            Telegram::sendMessage($chatId, "❌ فشل التصدير: " . $e->getMessage());
        }
    }
    
    /**
     * تصدير الأكواد
     * الصيغة: /export_codes [slug] [format?]
     * الصيغ: txt, csv, zip
     */
    private static function cmdExportCodes(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', trim($args));
        $slug = strtolower($parts[0] ?? '');
        $format = strtolower($parts[1] ?? 'txt');
        
        if (empty($slug)) {
            $text = "📤 <b>تصدير الأكواد</b>\n\n";
            $text .= "<b>الاستخدام:</b>\n<code>/export_codes [slug] [format?]</code>\n\n";
            $text .= "<b>الصيغ المتاحة:</b>\n";
            $text .= "• txt - ملف نصي منسق\n";
            $text .= "• csv - جدول بيانات\n";
            $text .= "• zip - ملف مضغوط (TXT + CSV + تعليمات)\n\n";
            $text .= "<b>أمثلة:</b>\n";
            $text .= "<code>/export_codes vip-acc</code>\n";
            $text .= "<code>/export_codes vip-acc csv</code>\n";
            $text .= "<code>/export_codes vip-acc zip</code>";
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        // جلب الحساب
        $account = Db::fetchOne("SELECT * FROM accounts WHERE slug = ?", [$slug]);
        if (!$account) {
            Telegram::sendMessage($chatId, "❌ الحساب غير موجود: {$slug}");
            return;
        }
        
        // جلب الأكواد غير المستخدمة
        $codes = Db::fetchAll(
            "SELECT code, created_at FROM activation_codes 
             WHERE account_id = ? AND status = 'unused'
             ORDER BY created_at DESC",
            [$account['id']]
        );
        
        if (empty($codes)) {
            Telegram::sendMessage($chatId, "📭 لا توجد أكواد غير مستخدمة لهذا الحساب.");
            return;
        }
        
        Telegram::sendMessage($chatId, "⏳ جاري تصدير " . count($codes) . " كود بصيغة {$format}...");
        
        try {
            $timestamp = date('Ymd_His');
            $accessInfo = $account['default_access_type'] === 'lifetime' 
                ? 'مدى الحياة (Lifetime)' 
                : $account['default_access_days'] . ' يوم';
            
            // تعليمات الاستخدام
            $instructions = "═══════════════════════════════════════\n";
            $instructions .= "📱 تعليمات استخدام كود التفعيل\n";
            $instructions .= "═══════════════════════════════════════\n\n";
            $instructions .= "🔹 الحساب: {$account['name']}\n";
            $instructions .= "🔹 المدة: {$accessInfo}\n\n";
            $instructions .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
            $instructions .= "🇸🇦 بالعربية:\n";
            $instructions .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
            $instructions .= "1. افتح البوت: @Get_Code_iq_Bot\n";
            $instructions .= "2. اشترك بالقناة: https://t.me/+i0rLO6U87dszOGQy\n";
            $instructions .= "3. أرسل الكود للبوت\n";
            $instructions .= "4. سيتم تفعيل حسابك فوراً ✅\n\n";
            $instructions .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
            $instructions .= "🇬🇧 In English:\n";
            $instructions .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
            $instructions .= "1. Open bot: @Get_Code_iq_Bot\n";
            $instructions .= "2. Join channel: https://t.me/+i0rLO6U87dszOGQy\n";
            $instructions .= "3. Send the code to the bot\n";
            $instructions .= "4. Your account will be activated instantly ✅\n";
            $instructions .= "═══════════════════════════════════════\n";
            
            if ($format === 'txt' || $format === 'zip') {
                // ملف TXT منسق
                $txtContent = "═══════════════════════════════════════\n";
                $txtContent .= "📦 أكواد التفعيل - {$account['name']}\n";
                $txtContent .= "═══════════════════════════════════════\n";
                $txtContent .= "📅 تاريخ التصدير: " . date('Y-m-d H:i:s') . "\n";
                $txtContent .= "🔢 عدد الأكواد: " . count($codes) . "\n";
                $txtContent .= "🔗 Slug: {$account['slug']}\n";
                $txtContent .= "⏱️ المدة: {$accessInfo}\n";
                $txtContent .= "═══════════════════════════════════════\n\n";
                
                $txtContent .= $instructions . "\n";
                
                $txtContent .= "═══════════════════════════════════════\n";
                $txtContent .= "📋 قائمة الأكواد:\n";
                $txtContent .= "═══════════════════════════════════════\n\n";
                
                $i = 1;
                foreach ($codes as $code) {
                    $txtContent .= sprintf("%3d. %s\n", $i++, $code['code']);
                }
                
                $txtContent .= "\n═══════════════════════════════════════\n";
                $txtContent .= "✅ نهاية الملف\n";
                $txtContent .= "═══════════════════════════════════════\n";
            }
            
            if ($format === 'csv' || $format === 'zip') {
                // ملف CSV
                $csvContent = "رقم,الكود,اسم الحساب,Slug,المدة,تاريخ الإنشاء\n";
                $csvContent .= "No,Code,Account Name,Slug,Duration,Created At\n";
                
                $i = 1;
                foreach ($codes as $code) {
                    $csvContent .= "{$i},{$code['code']},{$account['name']},{$account['slug']},{$accessInfo},{$code['created_at']}\n";
                    $i++;
                }
            }
            
            $tempPath = config('TEMP_PATH');
            
            if ($format === 'zip') {
                // إنشاء ملف ZIP
                $zipFilename = "codes_{$slug}_{$timestamp}.zip";
                $zipPath = $tempPath . $zipFilename;
                
                $zip = new \ZipArchive();
                if ($zip->open($zipPath, \ZipArchive::CREATE) !== true) {
                    throw new \Exception("فشل إنشاء ملف ZIP");
                }
                
                $zip->addFromString("codes_{$slug}.txt", $txtContent);
                $zip->addFromString("codes_{$slug}.csv", $csvContent);
                $zip->addFromString("instructions.txt", $instructions);
                $zip->close();
                
                Telegram::sendDocument($chatId, $zipPath, "✅ تم التصدير: " . count($codes) . " كود", $zipFilename);
                unlink($zipPath);
                
            } elseif ($format === 'csv') {
                $csvFilename = "codes_{$slug}_{$timestamp}.csv";
                $csvPath = $tempPath . $csvFilename;
                file_put_contents($csvPath, $csvContent);
                
                Telegram::sendDocument($chatId, $csvPath, "✅ تم التصدير: " . count($codes) . " كود", $csvFilename);
                unlink($csvPath);
                
            } else {
                // TXT
                $txtFilename = "codes_{$slug}_{$timestamp}.txt";
                $txtPath = $tempPath . $txtFilename;
                file_put_contents($txtPath, $txtContent);
                
                Telegram::sendDocument($chatId, $txtPath, "✅ تم التصدير: " . count($codes) . " كود", $txtFilename);
                unlink($txtPath);
            }
            
        } catch (Throwable $e) {
            Telegram::sendMessage($chatId, "❌ فشل التصدير: " . $e->getMessage());
        }
    }
    
    // ================================================================
    // دوال مساعدة
    // ================================================================
    
    private static function parseLimitsArgs(string $args): array
    {
        $limits = [];
        preg_match_all('/(\w+)=(\d+)/', $args, $matches, PREG_SET_ORDER);
        foreach ($matches as $m) { $limits[$m[1]] = (int)$m[2]; }
        return $limits;
    }
    
    // ================================================================
    // الأوامر الجديدة (V2) - نظام القسائم
    // ================================================================
    
    /**
     * إنشاء قسيمة جديدة
     * الصيغة: /create_voucher sd <account_ids> <days> [max_uses]
     * الصيغة: /create_voucher bundle <account_id> <codes_count> [access_type] [access_days]
     */
    private static function cmdCreateVoucher(int $chatId, string $args, int $fromId): void
    {
        $parts = preg_split('/\s+/', trim($args));
        
        if (count($parts) < 3) {
            $help = "🎟️ <b>إنشاء قسيمة</b>\n\n";
            $help .= "<b>قسيمة اشتراك موزع (sd):</b>\n";
            $help .= "<code>/create_voucher sd [account_ids] [days] [max_uses?]</code>\n";
            $help .= "مثال: <code>/create_voucher sd 1,2,3 30 1</code>\n\n";
            $help .= "<b>قسيمة حزمة أكواد (bundle):</b>\n";
            $help .= "<code>/create_voucher bundle [account_id] [codes_count] [type?] [days?]</code>\n";
            $help .= "مثال: <code>/create_voucher bundle 1 10 timed 30</code>\n";
            Telegram::sendMessage($chatId, $help);
            return;
        }
        
        $type = strtolower($parts[0]);
        
        if ($type === 'sd') {
            $accountIds = array_map('intval', explode(',', $parts[1]));
            $days = (int)$parts[2];
            $maxUses = (int)($parts[3] ?? 1);
            
            $payload = ['accounts' => []];
            foreach ($accountIds as $accId) {
                $payload['accounts'][] = ['account_id' => $accId, 'duration_days' => $days];
            }
            
            $result = Voucher::create(Voucher::TYPE_SD, $payload, [
                'max_uses' => $maxUses,
                'created_by_admin_id' => $fromId,
            ]);
            
        } elseif ($type === 'bundle') {
            $accountId = (int)$parts[1];
            $codesCount = (int)$parts[2];
            $accessType = $parts[3] ?? 'lifetime';
            $accessDays = isset($parts[4]) ? (int)$parts[4] : null;
            
            $payload = [
                'account_id' => $accountId,
                'codes_count' => $codesCount,
                'access_type' => $accessType,
                'access_days' => $accessDays,
            ];
            
            $result = Voucher::create(Voucher::TYPE_ACTIVATION_BUNDLE, $payload, [
                'max_uses' => 1,
                'created_by_admin_id' => $fromId,
            ]);
        } else {
            Telegram::sendMessage($chatId, "❌ نوع القسيمة غير صالح. استخدم: sd أو bundle");
            return;
        }
        
        if ($result['success']) {
            $text = "✅ <b>تم إنشاء القسيمة بنجاح!</b>\n\n";
            $text .= "🎟️ الكود: <code>{$result['code']}</code>\n";
            $text .= "🆔 المعرف: {$result['voucher_id']}\n";
            $text .= "📋 النوع: {$type}\n";
            Telegram::sendMessage($chatId, $text);
        } else {
            Telegram::sendMessage($chatId, "❌ فشل إنشاء القسيمة: {$result['error']}");
        }
    }
    
    /**
     * معلومات قسيمة
     */
    private static function cmdVoucherInfo(int $chatId, string $args): void
    {
        $code = trim($args);
        
        if (empty($code)) {
            Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/voucher_info [code]</code>");
            return;
        }
        
        $voucher = Voucher::getByCode($code);
        
        if (!$voucher) {
            Telegram::sendMessage($chatId, "❌ القسيمة غير موجودة: {$code}");
            return;
        }
        
        $payload = json_decode($voucher['payload'], true);
        
        $text = "🎟️ <b>معلومات القسيمة</b>\n\n";
        $text .= "🆔 المعرف: {$voucher['id']}\n";
        $text .= "📝 الكود: <code>{$voucher['code']}</code>\n";
        $text .= "📋 النوع: {$voucher['type']}\n";
        $text .= "📊 الحالة: {$voucher['status']}\n";
        $text .= "🔢 الاستخدام: {$voucher['current_uses']}/{$voucher['max_uses']}\n";
        
        if ($voucher['expires_at']) {
            $text .= "⏰ انتهاء الصلاحية: {$voucher['expires_at']}\n";
        }
        
        if ($voucher['payment_id']) {
            $text .= "\n💳 <b>الدفع:</b>\n";
            $text .= "• المعرف: {$voucher['payment_id']}\n";
            $text .= "• المزود: {$voucher['payment_provider']}\n";
            $text .= "• المبلغ: {$voucher['payment_amount']} {$voucher['payment_currency']}\n";
        }
        
        $text .= "\n📦 <b>البيانات:</b>\n";
        $text .= "<code>" . json_encode($payload, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</code>\n";
        
        $text .= "\n📅 تاريخ الإنشاء: {$voucher['created_at']}";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * قائمة القسائم
     */
    private static function cmdListVouchers(int $chatId, string $args): void
    {
        $filters = [];
        $parts = preg_split('/\s+/', trim($args));
        
        foreach ($parts as $part) {
            if (in_array($part, ['sd', 'activation_bundle'])) {
                $filters['type'] = $part;
            } elseif (in_array($part, ['unused', 'partial', 'used', 'expired', 'disabled'])) {
                $filters['status'] = $part;
            }
        }
        
        $vouchers = Voucher::getList($filters, 20);
        
        if (empty($vouchers)) {
            Telegram::sendMessage($chatId, "📭 لا توجد قسائم" . (!empty($filters) ? " بهذه المعايير" : ""));
            return;
        }
        
        $text = "🎟️ <b>قائمة القسائم</b>\n\n";
        
        foreach ($vouchers as $v) {
            $statusIcon = match($v['status']) {
                'unused' => '🟢',
                'partial' => '🟡',
                'used' => '⚫',
                'expired' => '🔴',
                'disabled' => '⛔',
                default => '❓',
            };
            
            $text .= "{$statusIcon} <code>{$v['code']}</code>\n";
            $text .= "   └ {$v['type']} | {$v['current_uses']}/{$v['max_uses']} | {$v['status']}\n";
        }
        
        $text .= "\n📖 /voucher_info [code] للتفاصيل";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * تعطيل قسيمة
     */
    private static function cmdDisableVoucher(int $chatId, string $args): void
    {
        $code = trim($args);
        
        if (empty($code)) {
            Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/disable_voucher [code]</code>");
            return;
        }
        
        $voucher = Voucher::getByCode($code);
        
        if (!$voucher) {
            Telegram::sendMessage($chatId, "❌ القسيمة غير موجودة: {$code}");
            return;
        }
        
        if (Voucher::disable($voucher['id'])) {
            Telegram::sendMessage($chatId, "✅ تم تعطيل القسيمة: {$code}");
        } else {
            Telegram::sendMessage($chatId, "❌ فشل تعطيل القسيمة");
        }
    }
    
    // ================================================================
    // إضافة حسابات دفعة واحدة
    // ================================================================
    
    /**
     * إضافة حسابات دفعة واحدة
     * الصيغة: /addaccounts_batch [--preview]
     * ثم إرسال البيانات بتنسيق CSV
     * 
     * صيغة CSV المطلوبة:
     * name,slug,secret_key,access_type,access_days
     * حساب 1,acc-1,KEY123,lifetime,
     * حساب 2,acc-2,KEY456,timed,30
     */
    private static function cmdAddAccountsBatch(int $chatId, string $args, int $fromId): void
    {
        $preview = str_contains($args, '--preview');
        
        // التحقق من وجود state سابق
        $state = State::get($fromId);
        
        if (!$state || ($state['state'] ?? '') !== 'batch_accounts_awaiting') {
            // بدء العملية - طلب البيانات
            State::set($fromId, 'admin', 'batch_accounts_awaiting', [
                'preview' => $preview,
            ]);
            
            $text = "📦 <b>إضافة حسابات دفعة واحدة</b>\n\n";
            $text .= "أرسل الآن ملف CSV أو الصق قائمة الحسابات بالصيغة التالية:\n\n";
            $text .= "<code>name,slug,secret_key,access_type,access_days\n";
            $text .= "حساب 1,acc-1,KEY123ABC,lifetime,\n";
            $text .= "حساب 2,acc-2,KEY456DEF,timed,30</code>\n\n";
            $text .= "📋 <b>الأعمدة:</b>\n";
            $text .= "• <b>name</b> - اسم الحساب (مطلوب)\n";
            $text .= "• <b>slug</b> - معرف فريد بأحرف إنجليزية صغيرة (مطلوب)\n";
            $text .= "• <b>secret_key</b> - المفتاح السري (مطلوب)\n";
            $text .= "• <b>access_type</b> - نوع الوصول: lifetime أو timed (مطلوب)\n";
            $text .= "• <b>access_days</b> - عدد الأيام (مطلوب إذا كان timed)\n\n";
            
            if ($preview) {
                $text .= "⚠️ <b>وضع المعاينة</b> - لن يتم الإدراج فعلياً\n";
            } else {
                $text .= "✅ سيتم الإدراج مباشرة بعد إرسال البيانات\n";
            }
            
            $text .= "\n/cancel للإلغاء";
            
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        // معالجة البيانات المرسلة
        State::clear($fromId);
        $isPreview = $state['data']['preview'] ?? false;
        
        $data = trim($args);
        
        if (empty($data)) {
            Telegram::sendMessage($chatId, "❌ لم يتم إرسال بيانات.\n\nاستخدم <code>/addaccounts_batch</code> للبدء من جديد.");
            return;
        }
        
        // معالجة البيانات
        $parseResult = self::parseAccountsBatchData($data);
        
        if (!$parseResult['success']) {
            Telegram::sendMessage($chatId, "❌ <b>خطأ في تحليل البيانات</b>\n\n" . $parseResult['error']);
            return;
        }
        
        $accounts = $parseResult['accounts'];
        $totalLines = count($accounts);
        
        if ($totalLines === 0) {
            Telegram::sendMessage($chatId, "❌ لا توجد حسابات صالحة للإضافة.");
            return;
        }
        
        // التحقق والتنفيذ
        $results = self::executeAccountsBatch($accounts, $isPreview);
        
        // إنشاء التقرير
        $text = self::generateBatchReport($results, $isPreview, $totalLines);
        
        Telegram::sendLongMessage($chatId, $text);
    }
    
    /**
     * تحليل بيانات CSV للحسابات
     */
    private static function parseAccountsBatchData(string $data): array
    {
        // إزالة BOM إذا وجد
        $data = preg_replace('/^\xEF\xBB\xBF/', '', $data);
        
        // تقسيم الأسطر
        $lines = preg_split('/\r\n|\r|\n/', $data);
        $accounts = [];
        $headers = null;
        $expectedHeaders = ['name', 'slug', 'secret_key', 'access_type', 'access_days'];
        
        foreach ($lines as $lineNum => $line) {
            $line = trim($line);
            
            // تجاهل الأسطر الفارغة
            if (empty($line)) continue;
            
            // تجاهل التعليقات
            if (str_starts_with($line, '#')) continue;
            
            $parts = str_getcsv($line);
            
            // السطر الأول = الـ headers
            if ($headers === null) {
                $headers = array_map(fn($h) => strtolower(trim($h)), $parts);
                
                // التحقق من الأعمدة المطلوبة
                $missing = array_diff(['name', 'slug', 'secret_key', 'access_type'], $headers);
                if (!empty($missing)) {
                    return [
                        'success' => false,
                        'error' => "الأعمدة المطلوبة غير موجودة: " . implode(', ', $missing) . "\n\nالأعمدة المطلوبة: name, slug, secret_key, access_type, access_days",
                    ];
                }
                continue;
            }
            
            // تحويل السطر لـ associative array
            $account = ['_line' => $lineNum + 1]; // رقم السطر الفعلي (1-indexed)
            foreach ($headers as $i => $header) {
                $account[$header] = trim($parts[$i] ?? '');
            }
            
            $accounts[] = $account;
        }
        
        if ($headers === null) {
            return [
                'success' => false,
                'error' => "لم يتم العثور على سطر العناوين.\n\nيجب أن يكون السطر الأول:\n<code>name,slug,secret_key,access_type,access_days</code>",
            ];
        }
        
        return ['success' => true, 'accounts' => $accounts];
    }
    
    /**
     * تنفيذ إضافة الحسابات
     */
    private static function executeAccountsBatch(array $accounts, bool $isPreview): array
    {
        $results = [
            'success' => 0,
            'failed' => 0,
            'errors' => [],
            'created' => [],
            'validated' => [],
        ];
        
        // التحقق أولاً من جميع الحسابات
        foreach ($accounts as $acc) {
            $lineNum = $acc['_line'];
            $validation = self::validateAccountRow($acc, $lineNum);
            
            if (!$validation['valid']) {
                $results['errors'][] = $validation['error'];
                $results['failed']++;
            } else {
                $results['validated'][] = $validation['account'];
            }
        }
        
        // إذا كانت معاينة فقط، لا نُدرج
        if ($isPreview) {
            $results['success'] = count($results['validated']);
            foreach ($results['validated'] as $acc) {
                $results['created'][] = [
                    'slug' => $acc['slug'],
                    'name' => $acc['name'],
                    'access_type' => $acc['access_type'],
                ];
            }
            return $results;
        }
        
        // الإدراج الفعلي
        if (!empty($results['validated'])) {
            Db::beginTransaction();
            
            try {
                foreach ($results['validated'] as $acc) {
                    Db::insert('accounts', [
                        'name' => $acc['name'],
                        'slug' => $acc['slug'],
                        'secret_key' => $acc['secret_key'],
                        'default_access_type' => $acc['access_type'],
                        'default_access_days' => $acc['access_days'],
                        'status' => 'active',
                    ]);
                    
                    $results['created'][] = [
                        'slug' => $acc['slug'],
                        'name' => $acc['name'],
                        'access_type' => $acc['access_type'],
                    ];
                    $results['success']++;
                }
                
                Db::commit();
                
            } catch (Throwable $e) {
                Db::rollback();
                $results['errors'][] = "❌ خطأ في قاعدة البيانات: " . $e->getMessage();
                $results['success'] = 0;
                $results['created'] = [];
            }
        }
        
        return $results;
    }
    
    /**
     * التحقق من صحة سطر حساب
     */
    private static function validateAccountRow(array $acc, int $lineNum): array
    {
        $slug = $acc['slug'] ?? '';
        $name = $acc['name'] ?? '';
        $secretKey = $acc['secret_key'] ?? '';
        $accessType = strtolower($acc['access_type'] ?? '');
        $accessDays = $acc['access_days'] ?? '';
        
        // 1. التحقق من الاسم
        if (empty($name)) {
            return ['valid' => false, 'error' => "سطر {$lineNum}: الاسم (name) مطلوب"];
        }
        
        // 2. التحقق من الـ slug
        if (empty($slug)) {
            return ['valid' => false, 'error' => "سطر {$lineNum}: المعرف (slug) مطلوب"];
        }
        
        if (str_contains($slug, ' ')) {
            return ['valid' => false, 'error' => "سطر {$lineNum}: المعرف (slug) يجب ألا يحتوي مسافات: '{$slug}'"];
        }
        
        if (!preg_match('/^[a-z0-9][a-z0-9-]*[a-z0-9]$|^[a-z0-9]$/', $slug)) {
            return ['valid' => false, 'error' => "سطر {$lineNum}: صيغة slug غير صالحة (يجب أحرف إنجليزية صغيرة وأرقام وشرطات): '{$slug}'"];
        }
        
        // 3. التحقق من التكرار
        if (Db::exists('accounts', 'slug = ?', [$slug])) {
            return ['valid' => false, 'error' => "سطر {$lineNum}: المعرف (slug) موجود مسبقاً: '{$slug}'"];
        }
        
        // 4. التحقق من المفتاح السري
        if (empty($secretKey)) {
            return ['valid' => false, 'error' => "سطر {$lineNum}: المفتاح السري (secret_key) مطلوب"];
        }
        
        // 5. التحقق من نوع الوصول
        if (!in_array($accessType, ['lifetime', 'timed'])) {
            return ['valid' => false, 'error' => "سطر {$lineNum}: نوع الوصول (access_type) يجب أن يكون 'lifetime' أو 'timed'، القيمة الحالية: '{$accessType}'"];
        }
        
        // 6. التحقق من أيام الوصول إذا كان timed
        $parsedDays = null;
        if ($accessType === 'timed') {
            if (empty($accessDays) || !is_numeric($accessDays) || (int)$accessDays <= 0) {
                return ['valid' => false, 'error' => "سطر {$lineNum}: عند اختيار 'timed'، يجب تحديد عدد أيام صحيح (access_days)"];
            }
            $parsedDays = (int)$accessDays;
        }
        
        return [
            'valid' => true,
            'account' => [
                'name' => $name,
                'slug' => $slug,
                'secret_key' => $secretKey,
                'access_type' => $accessType,
                'access_days' => $parsedDays,
                '_line' => $lineNum,
            ],
        ];
    }
    
    /**
     * إنشاء تقرير النتائج
     */
    private static function generateBatchReport(array $results, bool $isPreview, int $totalLines): string
    {
        $text = "";
        
        if ($isPreview) {
            $text .= "📋 <b>معاينة الإدراج</b>\n";
            $text .= "⚠️ <b>المعاينة فقط — لم يتم إضافة أي حساب</b>\n\n";
        } else {
            $text .= "✅ <b>نتيجة الإدراج</b>\n\n";
        }
        
        // الإحصائيات
        $text .= "📊 <b>الإحصائيات:</b>\n";
        $text .= "• إجمالي الأسطر: {$totalLines}\n";
        $text .= "• ✅ نجاح: {$results['success']}\n";
        $text .= "• ❌ فشل: {$results['failed']}\n\n";
        
        // الحسابات المُنشأة/التي ستُنشأ
        if (!empty($results['created'])) {
            $action = $isPreview ? "التي ستُنشأ" : "المُنشأة";
            $text .= "📦 <b>الحسابات {$action}:</b>\n";
            
            foreach (array_slice($results['created'], 0, 15) as $acc) {
                $type = $acc['access_type'] === 'lifetime' ? '♾️' : '⏱️';
                $text .= "• <code>{$acc['slug']}</code> - {$acc['name']} {$type}\n";
            }
            
            if (count($results['created']) > 15) {
                $remaining = count($results['created']) - 15;
                $text .= "• ... و {$remaining} حسابات أخرى\n";
            }
            $text .= "\n";
        }
        
        // الأخطاء
        if (!empty($results['errors'])) {
            $text .= "⚠️ <b>الأخطاء ({$results['failed']}):</b>\n";
            
            foreach (array_slice($results['errors'], 0, 10) as $err) {
                $text .= "• {$err}\n";
            }
            
            if (count($results['errors']) > 10) {
                $remaining = count($results['errors']) - 10;
                $text .= "• ... و {$remaining} أخطاء أخرى\n";
            }
        }
        
        // رسالة ختامية
        if ($isPreview && $results['success'] > 0) {
            $text .= "\n💡 لتنفيذ الإدراج فعلياً، استخدم:\n<code>/addaccounts_batch</code>\n(بدون --preview)";
        }
        
        return $text;
    }
    
    // ================================================================
    // فحص النظام (System Checker)
    // ================================================================
    
    /**
     * تشغيل فحص النظام
     */
    private static function cmdRunSystemCheck(int $chatId, string $args, int $fromId): void
    {
        $type = trim($args) ?: 'full';
        
        Telegram::sendMessage($chatId, "⏳ جاري تشغيل فحص النظام ({$type})...");
        
        try {
            $report = match($type) {
                'quick' => SystemChecker::runQuick($fromId, 'admin'),
                default => SystemChecker::runFull($fromId, 'admin'),
            };
            
            $text = "📊 <b>تقرير فحص النظام</b>\n\n";
            $text .= $report['summary'] . "\n\n";
            $text .= "⏱️ المدة: {$report['duration_ms']}ms\n";
            
            if (!empty($report['recommendations'])) {
                $text .= "\n💡 <b>توصيات:</b>\n";
                foreach (array_slice($report['recommendations'], 0, 5) as $rec) {
                    $text .= "• [{$rec['test']}] {$rec['recommendation']}\n";
                }
            }
            
            $text .= "\n📁 التقرير محفوظ في:\n<code>{$report['report_file_txt']}</code>";
            
            Telegram::sendMessage($chatId, $text);
            
        } catch (Throwable $e) {
            Telegram::sendMessage($chatId, "❌ فشل تشغيل الفحص: " . $e->getMessage());
        }
    }
    
    /**
     * قائمة تقارير الفحص
     */
    private static function cmdSystemReports(int $chatId, string $args): void
    {
        $limit = (int)($args ?: 10);
        $reports = SystemChecker::getReports($limit);
        
        if (empty($reports)) {
            Telegram::sendMessage($chatId, "📭 لا توجد تقارير فحص");
            return;
        }
        
        $text = "📊 <b>تقارير فحص النظام</b>\n\n";
        
        foreach ($reports as $r) {
            $icon = $r['failed_tests'] === 0 ? '✅' : '❌';
            $text .= "{$icon} <b>#{$r['id']}</b> - {$r['created_at']}\n";
            $text .= "   └ ✅{$r['passed_tests']} ❌{$r['failed_tests']} ⚠️{$r['warnings']} ({$r['duration_ms']}ms)\n";
        }
        
        $text .= "\n📖 /view_report [id] للتفاصيل";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * عرض تقرير محدد
     */
    private static function cmdViewReport(int $chatId, string $args): void
    {
        $id = (int)trim($args);
        
        if ($id <= 0) {
            Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/view_report [id]</code>");
            return;
        }
        
        $report = SystemChecker::getReport($id);
        
        if (!$report) {
            Telegram::sendMessage($chatId, "❌ التقرير غير موجود: {$id}");
            return;
        }
        
        $text = "📊 <b>تقرير فحص النظام #{$id}</b>\n\n";
        $text .= "📅 التاريخ: {$report['created_at']}\n";
        $text .= "🔧 النوع: {$report['check_type']}\n";
        $text .= "👤 المشغّل: {$report['triggered_by']}\n";
        $text .= "⏱️ المدة: {$report['duration_ms']}ms\n\n";
        
        $text .= "📊 <b>النتائج:</b>\n";
        $text .= "✅ نجاح: {$report['passed_tests']}\n";
        $text .= "❌ فشل: {$report['failed_tests']}\n";
        $text .= "⚠️ تحذيرات: {$report['warnings']}\n\n";
        
        $text .= "📝 <b>الملخص:</b>\n{$report['summary']}\n";
        
        if ($report['report_file_txt']) {
            $text .= "\n📁 الملف: <code>{$report['report_file_txt']}</code>";
        }
        
        Telegram::sendMessage($chatId, $text);
    }
    
    // ================================================================
    // إدارة القائمة السوداء للبث
    // ================================================================
    
    /**
     * إضافة كلمة للقائمة السوداء
     */
    private static function cmdBlacklistAdd(int $chatId, string $args, int $fromId): void
    {
        $parts = preg_split('/\s+/', trim($args), 3);
        
        if (count($parts) < 1 || empty($parts[0])) {
            $text = "🚫 <b>إضافة للقائمة السوداء</b>\n\n";
            $text .= "الاستخدام: <code>/blacklist_add [word] [type?] [severity?]</code>\n\n";
            $text .= "<b>الأنواع:</b> word, regex, domain\n";
            $text .= "<b>الخطورة:</b> block, warn, log\n\n";
            $text .= "مثال: <code>/blacklist_add porn word block</code>";
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        $word = $parts[0];
        $type = $parts[1] ?? 'word';
        $severity = $parts[2] ?? 'block';
        
        if (BroadcastFilter::addToBlacklist($word, $type, $severity, $fromId)) {
            Telegram::sendMessage($chatId, "✅ تمت إضافة \"{$word}\" للقائمة السوداء ({$type}, {$severity})");
        } else {
            Telegram::sendMessage($chatId, "❌ فشلت الإضافة (قد تكون موجودة مسبقاً)");
        }
    }
    
    /**
     * حذف كلمة من القائمة السوداء
     */
    private static function cmdBlacklistRemove(int $chatId, string $args): void
    {
        $id = (int)trim($args);
        
        if ($id <= 0) {
            Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/blacklist_remove [id]</code>");
            return;
        }
        
        if (BroadcastFilter::removeFromBlacklist($id)) {
            Telegram::sendMessage($chatId, "✅ تم حذف العنصر #{$id} من القائمة السوداء");
        } else {
            Telegram::sendMessage($chatId, "❌ فشل الحذف");
        }
    }
    
    /**
     * عرض القائمة السوداء
     */
    private static function cmdBlacklistList(int $chatId): void
    {
        $items = BroadcastFilter::getAllBlacklistItems();
        
        if (empty($items)) {
            Telegram::sendMessage($chatId, "📭 القائمة السوداء فارغة");
            return;
        }
        
        $text = "🚫 <b>القائمة السوداء للبث</b>\n\n";
        
        foreach ($items as $item) {
            $activeIcon = $item['is_active'] ? '🟢' : '🔴';
            $severityIcon = match($item['severity']) {
                'block' => '⛔',
                'warn' => '⚠️',
                'log' => '📝',
                default => '❓',
            };
            
            $text .= "{$activeIcon} #{$item['id']} {$severityIcon} <code>{$item['word']}</code>\n";
            $text .= "   └ {$item['type']} | {$item['severity']}\n";
        }
        
        $text .= "\n📖 /blacklist_remove [id] للحذف";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    // ================================================================
    // إعدادات البث
    // ================================================================
    
    /**
     * عرض إعدادات البث
     */
    private static function cmdBroadcastSettings(int $chatId, string $args): void
    {
        $settings = BroadcastFilter::getAllSettings();
        
        $text = "⚙️ <b>إعدادات البث</b>\n\n";
        
        foreach ($settings as $key => $value) {
            $text .= "• <code>{$key}</code> = {$value}\n";
        }
        
        $text .= "\n📝 /set_broadcast_setting [key] [value] للتعديل";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * تعديل إعداد بث
     */
    private static function cmdSetBroadcastSetting(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', trim($args), 2);
        
        if (count($parts) < 2) {
            Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/set_broadcast_setting [key] [value]</code>");
            return;
        }
        
        $key = $parts[0];
        $value = $parts[1];
        
        if (BroadcastFilter::setSetting($key, $value)) {
            Telegram::sendMessage($chatId, "✅ تم تعيين {$key} = {$value}");
        } else {
            Telegram::sendMessage($chatId, "❌ فشل تعيين الإعداد");
        }
    }
    
    /**
     * عرض البثات المحظورة
     */
    private static function cmdBlockedBroadcasts(int $chatId, string $args): void
    {
        $limit = (int)($args ?: 20);
        $blocked = BroadcastFilter::getBlockedBroadcasts($limit);
        
        if (empty($blocked)) {
            Telegram::sendMessage($chatId, "📭 لا توجد بثات محظورة");
            return;
        }
        
        $text = "🚫 <b>البثات المحظورة</b>\n\n";
        
        foreach ($blocked as $b) {
            $actionIcon = match($b['action_taken']) {
                'blocked' => '⛔',
                'warned' => '⚠️',
                'logged' => '📝',
                default => '❓',
            };
            
            $snippet = mb_substr($b['content_snippet'], 0, 50) . '...';
            $text .= "{$actionIcon} <b>#{$b['id']}</b> - {$b['created_at']}\n";
            $text .= "   └ {$b['broadcaster_type']} #{$b['broadcaster_id']}\n";
            $text .= "   └ \"{$snippet}\"\n";
            $text .= "   └ السبب: {$b['reason']}\n\n";
        }
        
        Telegram::sendMessage($chatId, $text);
    }
    
    // ================================================================
    // عرض الحدود
    // ================================================================
    
    /**
     * عرض الحدود العامة
     */
    private static function cmdViewGlobalLimits(int $chatId): void
    {
        $limits = Limits::getGlobalLimits();
        
        $text = "⚙️ <b>الحدود العامة</b>\n\n";
        $text .= "• يومي: " . ($limits['daily'] ?? 'بلا حد') . "\n";
        $text .= "• أسبوعي: " . ($limits['weekly'] ?? 'بلا حد') . "\n";
        $text .= "• شهري: " . ($limits['monthly'] ?? 'بلا حد') . "\n";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * عرض حدود الحسابات
     */
    private static function cmdViewAccountLimits(int $chatId, string $args): void
    {
        $args = trim($args);
        
        if ($args !== '') {
            // حدود حساب محدد
            $account = is_numeric($args) ? getAccountById((int)$args) : getAccountBySlug($args);
            if (!$account) {
                Telegram::sendMessage($chatId, "❌ الحساب غير موجود");
                return;
            }
            
            $limits = Limits::getAccountLimits($account['id']);
            
            $text = "📦 <b>حدود حساب {$account['name']}</b>\n\n";
            $text .= "• يومي: " . ($limits['daily'] ?? 'بلا حد') . "\n";
            $text .= "• أسبوعي: " . ($limits['weekly'] ?? 'بلا حد') . "\n";
            $text .= "• شهري: " . ($limits['monthly'] ?? 'بلا حد') . "\n";
        } else {
            // جميع الحسابات
            $accounts = Db::fetchAll("SELECT * FROM accounts ORDER BY id");
            
            $text = "📦 <b>حدود جميع الحسابات</b>\n\n";
            
            foreach ($accounts as $acc) {
                $limits = Limits::getAccountLimits($acc['id']);
                $hasLimits = $limits['daily'] !== null || $limits['weekly'] !== null || $limits['monthly'] !== null;
                
                if ($hasLimits) {
                    $text .= "<b>{$acc['name']}</b> (<code>{$acc['slug']}</code>)\n";
                    if ($limits['daily'] !== null) $text .= "  • يومي: {$limits['daily']}\n";
                    if ($limits['weekly'] !== null) $text .= "  • أسبوعي: {$limits['weekly']}\n";
                    if ($limits['monthly'] !== null) $text .= "  • شهري: {$limits['monthly']}\n";
                    $text .= "\n";
                }
            }
            
            if ($text === "📦 <b>حدود جميع الحسابات</b>\n\n") {
                $text .= "لا توجد حدود مخصصة للحسابات\n";
            }
        }
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * عرض حدود الموزعين
     */
    private static function cmdViewSuperDistLimits(int $chatId, string $args): void
    {
        $args = trim($args);
        
        if ($args !== '') {
            // حدود موزع محدد
            $superdist = Db::fetchOne("SELECT * FROM super_distributors WHERE id = ?", [(int)$args]);
            if (!$superdist) {
                Telegram::sendMessage($chatId, "❌ الموزع غير موجود");
                return;
            }
            
            $limits = Limits::getSuperDistLimits($superdist['id']);
            
            $text = "👥 <b>حدود الموزع {$superdist['display_name']}</b>\n\n";
            $text .= "• يومي: " . ($limits['daily'] ?? 'بلا حد') . "\n";
            $text .= "• أسبوعي: " . ($limits['weekly'] ?? 'بلا حد') . "\n";
            $text .= "• شهري: " . ($limits['monthly'] ?? 'بلا حد') . "\n";
        } else {
            // جميع الموزعين
            $superdists = Db::fetchAll("SELECT * FROM super_distributors WHERE status = 'active' ORDER BY id");
            
            $text = "👥 <b>حدود جميع الموزعين</b>\n\n";
            
            foreach ($superdists as $sd) {
                $limits = Limits::getSuperDistLimits($sd['id']);
                $hasLimits = $limits['daily'] !== null || $limits['weekly'] !== null || $limits['monthly'] !== null;
                
                if ($hasLimits) {
                    $text .= "<b>#{$sd['id']} {$sd['display_name']}</b>\n";
                    if ($limits['daily'] !== null) $text .= "  • يومي: {$limits['daily']}\n";
                    if ($limits['weekly'] !== null) $text .= "  • أسبوعي: {$limits['weekly']}\n";
                    if ($limits['monthly'] !== null) $text .= "  • شهري: {$limits['monthly']}\n";
                    $text .= "\n";
                }
            }
            
            if ($text === "👥 <b>حدود جميع الموزعين</b>\n\n") {
                $text .= "لا توجد حدود مخصصة للموزعين\n";
            }
        }
        
        Telegram::sendLongMessage($chatId, $text);
    }
    
    /**
     * عرض حدود المستخدمين
     */
    private static function cmdViewUserLimits(int $chatId, string $args): void
    {
        $telegramId = trim($args);
        
        if ($telegramId === '') {
            // عرض قائمة المستخدمين مع حدود مخصصة
            $usersWithLimits = Db::fetchAll("SELECT DISTINCT user_id FROM limits_user ORDER BY user_id LIMIT 50");
            
            $text = "👤 <b>المستخدمين مع حدود مخصصة</b>\n\n";
            
            foreach ($usersWithLimits as $ul) {
                $limits = Limits::getUserLimits($ul['user_id']);
                $user = Db::fetchOne("SELECT * FROM users WHERE telegram_id = ?", [$ul['user_id']]);
                $name = $user['first_name'] ?? "TG:{$ul['user_id']}";
                
                $text .= "<b>{$name}</b>\n";
                if ($limits['daily'] !== null) $text .= "  • يومي: {$limits['daily']}\n";
                if ($limits['weekly'] !== null) $text .= "  • أسبوعي: {$limits['weekly']}\n";
                if ($limits['monthly'] !== null) $text .= "  • شهري: {$limits['monthly']}\n";
                $text .= "\n";
            }
            
            if (empty($usersWithLimits)) {
                $text .= "لا توجد حدود مخصصة للمستخدمين\n";
            }
        } else {
            // حدود مستخدم محدد
            $limits = Limits::getUserLimits((int)$telegramId);
            
            $text = "👤 <b>حدود المستخدم {$telegramId}</b>\n\n";
            $text .= "• يومي: " . ($limits['daily'] ?? 'بلا حد') . "\n";
            $text .= "• أسبوعي: " . ($limits['weekly'] ?? 'بلا حد') . "\n";
            $text .= "• شهري: " . ($limits['monthly'] ?? 'بلا حد') . "\n";
        }
        
        Telegram::sendLongMessage($chatId, $text);
    }
    
    // ================================================================
    // معالجة الأكواد والإعدادات
    // ================================================================
    
    /**
     * معالجة الأكواد ضمن نافذة زمنية
     * الصيغة: /process_codes_window <mode> <value> <action> [--account=slug] [--superdist=id]
     */
    private static function cmdProcessCodesWindow(int $chatId, string $args, int $fromId): void
    {
        $parts = preg_split('/\s+/', trim($args));
        
        if (count($parts) < 3) {
            $text = "❌ <b>الاستخدام:</b>\n";
            $text .= "<code>/process_codes_window mode value action [options]</code>\n\n";
            $text .= "<b>الأنماط (mode):</b>\n";
            $text .= "• <code>since</code> - منذ تاريخ (YYYY-MM-DD أو 30d)\n";
            $text .= "• <code>last_n</code> - آخر N كود\n\n";
            $text .= "<b>الإجراءات (action):</b>\n";
            $text .= "• <code>expire_unused</code> - تحويل للمنتهي\n";
            $text .= "• <code>disable_unused</code> - تعطيل\n";
            $text .= "• <code>report_only</code> - تقرير فقط\n\n";
            $text .= "<b>الخيارات:</b>\n";
            $text .= "• <code>--account=slug</code>\n";
            $text .= "• <code>--superdist=id</code>\n\n";
            $text .= "<b>أمثلة:</b>\n";
            $text .= "<code>/process_codes_window since 30d report_only</code>\n";
            $text .= "<code>/process_codes_window last_n 500 expire_unused --account=vip</code>\n";
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        $mode = strtolower($parts[0]);
        $value = $parts[1];
        $action = strtolower($parts[2]);
        
        // تحليل الخيارات
        $accountId = null;
        $superdistId = null;
        
        foreach ($parts as $part) {
            if (str_starts_with($part, '--account=')) {
                $slug = substr($part, 10);
                $account = getAccountBySlug($slug);
                $accountId = $account ? $account['id'] : null;
            }
            if (str_starts_with($part, '--superdist=')) {
                $superdistId = (int)substr($part, 12);
            }
        }
        
        // التحقق من الصحة
        if (!in_array($mode, ['since', 'last_n'])) {
            Telegram::sendMessage($chatId, "❌ النمط غير صالح: {$mode}");
            return;
        }
        
        if (!in_array($action, ['expire_unused', 'disable_unused', 'report_only'])) {
            Telegram::sendMessage($chatId, "❌ الإجراء غير صالح: {$action}");
            return;
        }
        
        Telegram::sendMessage($chatId, "⏳ جاري معالجة الأكواد...");
        
        // تنفيذ المعالجة
        $result = ProcessCodesWindow::run($mode, $value, $action, $accountId, $superdistId, $fromId);
        
        if ($result['success']) {
            $text = "✅ <b>اكتملت المعالجة</b>\n\n";
            $text .= "📊 <b>الإحصائيات:</b>\n";
            $text .= "• الإجمالي: {$result['total']}\n";
            $text .= "• تمت معالجتها: {$result['processed']}\n";
            $text .= "• تأثرت: {$result['affected']}\n";
            $text .= "• تخطّت: {$result['skipped']}\n\n";
            $text .= "📁 <b>الملفات:</b>\n";
            $text .= "• JSON: <code>" . basename($result['report_path']) . "</code>\n";
            $text .= "• CSV: <code>" . basename($result['csv_path']) . "</code>\n";
            $text .= "\n🔗 Job ID: {$result['job_id']}";
        } else {
            $text = "❌ فشلت المعالجة:\n{$result['error']}";
        }
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * تعيين إعداد
     * الصيغة: /set_setting <level> <id?> <key>=<value>
     */
    private static function cmdSetSetting(int $chatId, string $args, int $fromId): void
    {
        $parts = preg_split('/\s+/', trim($args));
        
        if (count($parts) < 2) {
            $text = "❌ <b>الاستخدام:</b>\n";
            $text .= "<code>/set_setting level [id] key=value</code>\n\n";
            $text .= "<b>المستويات:</b> global, account, superdist, user, user_account\n\n";
            $text .= "<b>أمثلة:</b>\n";
            $text .= "<code>/set_setting global activation_default_days=30</code>\n";
            $text .= "<code>/set_setting superdist 5 daily_activation_limit=100</code>\n";
            $text .= "<code>/set_setting account vip-acc voucher_redeem_allowed=false</code>\n";
            Telegram::sendMessage($chatId, $text);
            return;
        }
        
        $level = strtolower($parts[0]);
        
        if (!Settings::isValidLevel($level)) {
            Telegram::sendMessage($chatId, "❌ المستوى غير صالح: {$level}");
            return;
        }
        
        // تحليل المعاملات
        $levelId = null;
        $levelId2 = null;
        $keyValue = null;
        
        if ($level === 'global') {
            // global key=value
            $keyValue = $parts[1] ?? '';
        } elseif ($level === 'user_account') {
            // user_account telegram_id account_slug key=value
            if (count($parts) < 4) {
                Telegram::sendMessage($chatId, "❌ المستوى user_account يتطلب: telegram_id account_slug key=value");
                return;
            }
            $levelId = $parts[1];
            $levelId2 = $parts[2];
            $keyValue = $parts[3];
        } else {
            // account/superdist/user id key=value
            if (count($parts) < 3) {
                Telegram::sendMessage($chatId, "❌ المستوى {$level} يتطلب: id key=value");
                return;
            }
            $levelId = $parts[1];
            $keyValue = $parts[2];
        }
        
        // تحليل key=value
        if (!str_contains($keyValue, '=')) {
            Telegram::sendMessage($chatId, "❌ صيغة خاطئة. استخدم: key=value");
            return;
        }
        
        [$key, $value] = explode('=', $keyValue, 2);
        
        // تحويل القيمة
        if ($value === 'true') $value = true;
        elseif ($value === 'false') $value = false;
        elseif (is_numeric($value)) $value = strpos($value, '.') !== false ? (float)$value : (int)$value;
        elseif (str_starts_with($value, '[') || str_starts_with($value, '{')) $value = json_decode($value, true) ?? $value;
        
        // تعيين الإعداد
        if (Settings::set($key, $value, $level, $levelId, $levelId2, $fromId)) {
            $text = "✅ <b>تم تعيين الإعداد</b>\n\n";
            $text .= "• المستوى: {$level}\n";
            if ($levelId) $text .= "• المعرف: {$levelId}\n";
            if ($levelId2) $text .= "• المعرف الثانوي: {$levelId2}\n";
            $text .= "• المفتاح: {$key}\n";
            $text .= "• القيمة: " . (is_array($value) ? json_encode($value) : $value) . "\n";
        } else {
            $text = "❌ فشل تعيين الإعداد";
        }
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * جلب إعداد
     */
    private static function cmdGetSetting(int $chatId, string $args): void
    {
        $parts = preg_split('/\s+/', trim($args));
        
        if (count($parts) < 2) {
            Telegram::sendMessage($chatId, "❌ الاستخدام: <code>/get_setting level [id] key</code>");
            return;
        }
        
        $level = strtolower($parts[0]);
        
        if ($level === 'global') {
            $key = $parts[1];
            $value = Settings::getFromLevel($key, $level);
        } else {
            if (count($parts) < 3) {
                Telegram::sendMessage($chatId, "❌ يتطلب: level id key");
                return;
            }
            $levelId = $parts[1];
            $key = $parts[2];
            $value = Settings::getFromLevel($key, $level, $levelId);
        }
        
        if ($value === null) {
            // جلب القيمة الافتراضية
            $defaults = Settings::getDefaults();
            $value = $defaults[$key] ?? 'غير موجود';
            $source = 'افتراضي';
        } else {
            $source = $level;
        }
        
        $text = "⚙️ <b>قيمة الإعداد</b>\n\n";
        $text .= "• المفتاح: {$key}\n";
        $text .= "• القيمة: " . (is_array($value) ? json_encode($value, JSON_UNESCAPED_UNICODE) : $value) . "\n";
        $text .= "• المصدر: {$source}\n";
        
        Telegram::sendMessage($chatId, $text);
    }
    
    /**
     * عرض جميع الإعدادات
     */
    private static function cmdViewSettings(int $chatId, string $args): void
    {
        $level = trim($args) ?: 'global';
        
        if ($level === 'all') {
            $settings = Settings::getAll();
            $text = "⚙️ <b>جميع الإعدادات</b>\n\n";
            
            $currentLevel = '';
            foreach ($settings as $s) {
                if ($s['level'] !== $currentLevel) {
                    $currentLevel = $s['level'];
                    $text .= "\n<b>━━ {$currentLevel} ━━</b>\n";
                }
                
                $id = $s['level_id'] ? "({$s['level_id']})" : '';
                $text .= "• <code>{$s['setting_key']}</code> {$id} = {$s['setting_value']}\n";
            }
        } else {
            $settings = Settings::getAllForLevel($level);
            
            $text = "⚙️ <b>إعدادات {$level}</b>\n\n";
            
            if (empty($settings)) {
                $text .= "لا توجد إعدادات مخصصة\n";
            } else {
                foreach ($settings as $key => $value) {
                    $displayValue = is_array($value) ? json_encode($value, JSON_UNESCAPED_UNICODE) : $value;
                    $text .= "• <code>{$key}</code> = {$displayValue}\n";
                }
            }
        }
        
        // الإعدادات الافتراضية
        $text .= "\n<b>📋 الإعدادات الافتراضية:</b>\n";
        foreach (Settings::getDefaults() as $key => $value) {
            $displayValue = is_array($value) ? json_encode($value) : $value;
            $text .= "• <code>{$key}</code> = {$displayValue}\n";
        }
        
        Telegram::sendLongMessage($chatId, $text);
    }
}
