# دليل نشر النظام (Deployment Guide)

## نظرة عامة

هذا الدليل يشرح خطوات نشر نظام إدارة أكواد التحقق على استضافة مشتركة (cPanel).

---

## المتطلبات

### متطلبات الخادم
- PHP 8.0 أو أعلى
- MySQL 5.7+ أو MariaDB 10.3+
- cURL extension
- JSON extension
- PDO extension

### متطلبات تيليجرام
- بوت إدارة (Admin Bot) + Token
- بوت عام (Public Bot) + Token
- قناة (اختياري) + Channel ID
- معرفات الأدمن (ADMIN_IDS)

---

## الخطوة 1: إعداد قاعدة البيانات

### 1.1 إنشاء قاعدة البيانات
1. افتح cPanel → MySQL Databases
2. أنشئ قاعدة بيانات جديدة: `username_botdb`
3. أنشئ مستخدم: `username_botuser`
4. امنح المستخدم صلاحيات كاملة على القاعدة

### 1.2 استيراد الجداول
1. افتح phpMyAdmin
2. اختر القاعدة المُنشأة
3. Import → اختر ملف `sql/schema.sql`
4. انقر Go

### 1.3 التحقق
```sql
SHOW TABLES;
-- يجب أن ترى 15+ جدول
```

---

## الخطوة 2: إعداد ملفات التكوين

### 2.1 ملف env.php
انسخ ملف `config/env.example.php` إلى `config/env.php` وعدّله:

```php
<?php
return [
    // قاعدة البيانات
    'DB_HOST' => 'localhost',
    'DB_NAME' => 'username_botdb',
    'DB_USER' => 'username_botuser',
    'DB_PASS' => 'YOUR_DB_PASSWORD',
    
    // توكنات البوتات
    'ADMIN_BOT_TOKEN'  => '123456789:AAxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
    'PUBLIC_BOT_TOKEN' => '987654321:AAyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy',
    
    // معرفات الأدمن
    'ADMIN_IDS' => [123456789, 987654321],
    
    // القناة
    'CHANNEL_ID'   => '-1001234567890',
    'CHANNEL_LINK' => 'https://t.me/your_channel',
    
    // مسارات
    'LOG_PATH'  => __DIR__ . '/../logs/',
    'TEMP_PATH' => __DIR__ . '/../temp/',
    
    // إعدادات
    'MAX_CODES_PER_REQUEST' => 50,
    'DEBUG_MODE' => false,
];
```

### 2.2 ملف limits.php
عدّل `config/limits.php` حسب احتياجاتك:

```php
<?php
return [
    'global' => [
        'verification' => [
            'daily'   => 2,
            'weekly'  => 10,
            'monthly' => 30,
        ],
    ],
];
```

---

## الخطوة 3: رفع الملفات

### 3.1 هيكل الملفات المطلوب
```
public_html/
├── admin_bot.php
├── public_bot.php
├── config/
│   ├── env.php
│   └── limits.php
├── libs/
│   ├── bootstrap.php
│   ├── Db.php
│   ├── Telegram.php
│   └── ...
├── src/
│   ├── admin/
│   │   └── Commands.php
│   └── public/
│       ├── SuperDistributorCommands.php
│       └── UserCommands.php
├── cron/
│   ├── daily_reset.php
│   ├── weekly_reset.php
│   ├── monthly_reset.php
│   ├── superdist_expiry.php
│   └── cleanup.php
├── logs/
│   └── .gitkeep
├── temp/
│   └── .gitkeep
└── sql/
    └── schema.sql
```

### 3.2 رفع الملفات
1. استخدم FTP أو File Manager في cPanel
2. ارفع جميع الملفات للمسار المطلوب
3. تأكد من صلاحيات المجلدات:
   - `logs/` → 755 أو 775
   - `temp/` → 755 أو 775

---

## الخطوة 4: إعداد Webhooks

### 4.1 Webhook لبوت الإدارة
افتح الرابط في المتصفح:
```
https://api.telegram.org/bot{ADMIN_BOT_TOKEN}/setWebhook?url=https://your-domain.com/admin_bot.php
```

### 4.2 Webhook للبوت العام
```
https://api.telegram.org/bot{PUBLIC_BOT_TOKEN}/setWebhook?url=https://your-domain.com/public_bot.php
```

### 4.3 التحقق من الـ Webhook
```
https://api.telegram.org/bot{TOKEN}/getWebhookInfo
```

يجب أن ترى:
```json
{
  "ok": true,
  "result": {
    "url": "https://your-domain.com/admin_bot.php",
    "has_custom_certificate": false,
    "pending_update_count": 0
  }
}
```

---

## الخطوة 5: إعداد Cron Jobs

### 5.1 فتح Cron Jobs في cPanel
cPanel → Cron Jobs

### 5.2 إضافة المهام

| المهمة | التوقيت | الأمر |
|--------|---------|-------|
| يومي | `0 0 * * *` | `/usr/bin/php /home/username/public_html/cron/daily_reset.php` |
| أسبوعي | `0 0 * * 6` | `/usr/bin/php /home/username/public_html/cron/weekly_reset.php` |
| شهري | `0 0 1 * *` | `/usr/bin/php /home/username/public_html/cron/monthly_reset.php` |
| انتهاء SD | `0 1 * * *` | `/usr/bin/php /home/username/public_html/cron/superdist_expiry.php` |
| تنظيف | `0 3 * * *` | `/usr/bin/php /home/username/public_html/cron/cleanup.php` |

### 5.3 ملاحظة
استبدل `/home/username/public_html/` بالمسار الفعلي لموقعك.  
يمكنك معرفة المسار بتنفيذ: `echo __DIR__;` في ملف PHP.

---

## الخطوة 6: الاختبار

### 6.1 اختبار بوت الإدارة
1. أرسل `/start` لبوت الإدارة
2. يجب أن تتلقى رسالة الترحيب
3. جرّب `/help`

### 6.2 اختبار البوت العام
1. أرسل `/start` للبوت العام
2. يجب أن تتلقى رسالة الترحيب

### 6.3 اختبار قاعدة البيانات
```sql
-- في phpMyAdmin
SELECT * FROM replies LIMIT 5;
SELECT * FROM limits_global;
```

### 6.4 اختبار Cron
```bash
# عبر SSH أو Terminal في cPanel
php /home/username/public_html/cron/daily_reset.php
```

---

## الخطوة 7: إعداد أول حساب

### 7.1 إضافة حساب
في بوت الإدارة:
```
/addaccount vip-2025 | حساب VIP 2025 | SECRET_KEY_HERE
```

### 7.2 إنشاء كود سوبر موزع
```
/createsuperdistcode new 1 30 1
```

### 7.3 تفعيل السوبر موزع
أرسل الكود للبوت العام من حساب السوبر موزع.

---

## استكشاف الأخطاء

### خطأ 500
1. تحقق من ملف `logs/error.log`
2. تأكد من صحة بيانات قاعدة البيانات
3. تأكد من وجود جميع الملفات

### البوت لا يستجيب
1. تحقق من صحة الـ Token
2. تحقق من الـ Webhook عبر `getWebhookInfo`
3. تحقق من وجود أخطاء في `logs/`

### خطأ في قاعدة البيانات
1. تأكد من صحة بيانات الاتصال
2. تأكد من أن المستخدم لديه صلاحيات
3. تأكد من استيراد `schema.sql`

### Cron لا يعمل
1. تأكد من المسار الصحيح
2. تأكد من صلاحيات التنفيذ
3. جرّب التنفيذ يدوياً عبر SSH

---

## قائمة التحقق النهائية

| # | البند | الحالة |
|---|-------|--------|
| 1 | قاعدة البيانات منشأة | ⬜ |
| 2 | schema.sql مستورد | ⬜ |
| 3 | env.php معدّل | ⬜ |
| 4 | الملفات مرفوعة | ⬜ |
| 5 | صلاحيات logs/ و temp/ | ⬜ |
| 6 | Webhook بوت الإدارة | ⬜ |
| 7 | Webhook البوت العام | ⬜ |
| 8 | Cron Jobs مضافة | ⬜ |
| 9 | اختبار /start للإدارة | ⬜ |
| 10 | اختبار /start للعام | ⬜ |
| 11 | إضافة أول حساب | ⬜ |
| 12 | إنشاء أول سوبر موزع | ⬜ |

---

## الأوامر السريعة للتأكد

```bash
# التأكد من PHP
php -v

# التأكد من اتصال قاعدة البيانات
php -r "new PDO('mysql:host=localhost;dbname=DB_NAME', 'USER', 'PASS');"

# اختبار Webhook
curl -X POST https://your-domain.com/admin_bot.php \
  -H "Content-Type: application/json" \
  -d '{"update_id":1,"message":{"message_id":1,"from":{"id":123},"chat":{"id":123},"text":"/start"}}'

# تشغيل Cron يدوياً
php /home/username/public_html/cron/daily_reset.php
```

---

## الدعم

في حال وجود مشاكل:
1. راجع ملفات السجلات في `logs/`
2. فعّل `DEBUG_MODE` في `env.php`
3. راجع سيناريوهات الاختبار في `TEST_SCENARIOS.md`
