<?php
/**
 * ============================================================
 * Cron Runner - منفذ مهام الـ Cron عبر HTTP
 * ============================================================
 * 
 * هذا الملف يسمح بتشغيل مهام cron عبر wget/curl مع حماية بـ secret key
 * 
 * الاستخدام:
 *   wget -q -O- "https://domain.com/cron/run.php?job=daily&key=YOUR_SECRET_KEY"
 * 
 * المهام المتاحة:
 *   - daily       : تصفير يومي
 *   - weekly      : تصفير أسبوعي
 *   - monthly     : تصفير شهري
 *   - expiry      : فحص انتهاء صلاحيات الموزعين
 *   - cleanup     : تنظيف الملفات والسجلات القديمة
 */

// ============================================================
// مفتاح الحماية - غيّره إلى قيمة سرية خاصة بك!
// ============================================================
define('CRON_SECRET_KEY', 'MySecretKey_Bx9f7Kq2Z4vT8pN6sR1yU0wE3cH5mLz');

// ============================================================
// التحقق من المفتاح
// ============================================================
$providedKey = $_GET['key'] ?? '';

if ($providedKey !== CRON_SECRET_KEY) {
    http_response_code(403);
    exit('Access Denied');
}

// ============================================================
// السماح بتشغيل ملفات cron
// ============================================================
define('CRON_ALLOWED', true);

// ============================================================
// تحديد المهمة المطلوبة
// ============================================================
$job = $_GET['job'] ?? '';

$jobs = [
    'daily'   => 'daily_reset.php',
    'weekly'  => 'weekly_reset.php',
    'monthly' => 'monthly_reset.php',
    'expiry'  => 'superdist_expiry.php',
    'cleanup' => 'cleanup.php',
];

if (!isset($jobs[$job])) {
    http_response_code(400);
    echo "Invalid job. Available jobs: " . implode(', ', array_keys($jobs));
    exit;
}

// ============================================================
// تشغيل المهمة
// ============================================================
$jobFile = __DIR__ . '/' . $jobs[$job];

if (!file_exists($jobFile)) {
    http_response_code(404);
    exit("Job file not found: {$jobs[$job]}");
}

// تنفيذ المهمة
require $jobFile;
