# دمج نظام إدارة صلاحيات الوصول الدفعي

## الملفات المضافة

1. **sql/migrations/004_batch_access_management.sql**
   - إضافة حقول `default_access_type`, `default_access_days`, `default_inherit_global` لجدول `accounts`
   - إنشاء جدول `admin_audit` للتدقيق
   - إنشاء جدول `global_settings` للإعدادات العامة
   - إنشاء جدول `batch_operations` لتتبع العمليات الكبيرة
   - Stored procedures و Views مساعدة

2. **libs/BatchAccessManager.php**
   - `previewUsersAccessChange()` - معاينة التغييرات
   - `executeUsersAccessChange()` - تنفيذ التغييرات
   - `setDefaultAccountAccess()` - ضبط الوصول الافتراضي
   - `getDefaultAccountAccess()` - جلب الوصول الافتراضي
   - `listAccountsWithDefaultInherit()` - قائمة الحسابات

3. **src/admin/BatchAccessCommands.php**
   - `cmdSetUsersAccess()` - تغيير صلاحيات الزبائن دفعة
   - `cmdSetDefaultAccountAccess()` - ضبط الوصول الافتراضي
   - `cmdGetDefaultAccountAccess()` - عرض الوصول الافتراضي
   - `cmdListAccountsWithDefaultInherit()` - قائمة الحسابات
   - `cmdBatchOperationStatus()` - حالة العملية

## التكامل مع AdminCommands.php

أضف في بداية ملف `src/admin/Commands.php`:

```php
require_once __DIR__ . '/BatchAccessCommands.php';
```

أضف في دالة `handle()` داخل switch statement (السطور 145-150):

```php
// إدارة صلاحيات الوصول الدفعي
case '/set_users_access': 
    BatchAccessCommands::cmdSetUsersAccess($chatId, $args, $fromId); 
    break;
case '/set_default_account_access': 
    BatchAccessCommands::cmdSetDefaultAccountAccess($chatId, $args, $fromId); 
    break;
case '/get_default_account_access': 
    BatchAccessCommands::cmdGetDefaultAccountAccess($chatId, $args); 
    break;
case '/list_accounts_with_default_inherit': 
    BatchAccessCommands::cmdListAccountsWithDefaultInherit($chatId, $args); 
    break;
case '/batch_operation_status': 
    BatchAccessCommands::cmdBatchOperationStatus($chatId, $args); 
    break;
```

## التكامل مع bootstrap.php

أضف في `libs/bootstrap.php`:

```php
require_once __DIR__ . '/BatchAccessManager.php';
```

## أمثلة الاستخدام

### 1. معاينة تغيير صلاحيات الوصول
```
/set_users_access vip-acc,premium-acc timed 30 --preview
```

**النتيجة:**
```
📋 معاينة تغيير صلاحيات الوصول
⚠️ المعاينة فقط — لم يتم تطبيق أي تغيير

━━━━━━━━━━━━━━━━━━━━
📊 الإحصائيات:
• إجمالي السجلات المتأثرة: 124
• عدد الزبائن الفريدين: 98
• عدد الحسابات: 2

📈 التوزيع الحالي:
• Lifetime: 45
• Timed: 79

⚠️ تحذير: يوجد 45 اشتراك lifetime لن يتم تغييره
💡 استخدم --force لتغيير اشتراكات lifetime أيضاً

━━━━━━━━━━━━━━━━━━━━
🔄 التغيير المقترح:
• النوع الجديد: ⏱️ Timed (30 يوم)

⏱️ الوقت المتوقع: ~2 ثانية

━━━━━━━━━━━━━━━━━━━━
📝 عينة من السجلات (أول 5):

• TG:123456789 - حساب VIP
  └ حالياً: ♾️
• TG:987654321 - حساب Premium
  └ حالياً: ⏱️ 15d

━━━━━━━━━━━━━━━━━━━━
💡 لتنفيذ التغيير فعلياً:
/set_users_access 1,2 timed 30
```

### 2. تنفيذ التغيير
```
/set_users_access vip-acc timed 30 --force --notify
```

**النتيجة:**
```
✅ تم تنفيذ التغيير بنجاح!

━━━━━━━━━━━━━━━━━━━━
📊 النتائج:
• السجلات المحدثة: 124
• الأخطاء: 0
• وقت التنفيذ: 1850ms

🎯 التغيير: تم تحويل الاشتراكات إلى ⏱️ Timed (30 يوم)

📧 تم إرسال إشعارات للزبائن المتأثرين
```

### 3. ضبط الوصول الافتراضي للحساب
```
/set_default_account_access vip-acc timed 30
```

**النتيجة:**
```
✅ تم تحديث الإعدادات الافتراضية

• نجح: 1
• فشل: 0

⏱️ الوصول الافتراضي: Timed (30 يوم)
```

### 4. عرض الوصول الافتراضي
```
/get_default_account_access vip-acc
```

**النتيجة:**
```
⚙️ الوصول الافتراضي - حساب VIP

━━━━━━━━━━━━━━━━━━━━
📦 معلومات الحساب:
• ID: 5
• Slug: vip-acc

━━━━━━━━━━━━━━━━━━━━
🎯 الإعدادات الحالية:
• المصدر: 📦 إعدادات الحساب
• النوع: ⏱️ Timed (30 يوم)
```

### 5. قائمة الحسابات التي ترث الإعدادات العامة
```
/list_accounts_with_default_inherit
```

**النتيجة:**
```
🌐 الحسابات التي ترث الإعدادات العامة

📊 الصفحة 1 من 1 (إجمالي: 3)

📦 حساب Basic (basic-acc)
   └ 👥 45 زبون نشط

📦 حساب Standard (standard-acc)
   └ 👥 78 زبون نشط

📦 حساب Trial (trial-acc)
   └ 👥 12 زبون نشط
```

## Flags المدعومة

| Flag | الوصف |
|------|-------|
| `--preview` | معاينة فقط بدون تنفيذ |
| `--force` | تغيير اشتراكات lifetime أيضاً |
| `--notify` | إرسال إشعارات للزبائن |

## Audit Logging

جميع العمليات يتم تسجيلها في جدول `admin_audit`:
- من قام بالعملية (admin_id, admin_telegram_id)
- نوع العملية (action)
- الأهداف المتأثرة (target_ids)
- القيم القديمة والجديدة (old_values, new_values)
- عدد السجلات المتأثرة (affected_count)
- وقت التنفيذ (execution_time_ms)
- الحالة (status: success, partial, failed)

## Performance

- العمليات الكبيرة (>5000 سجل) يتم تنفيذها على دفعات (chunks) بحجم 500 سجل
- استخدام transactions لضمان atomicity
- قفل السجلات (FOR UPDATE) لمنع race conditions
- تقدير الوقت المتوقع في المعاينة

## Security

- جميع الأوامر محمية بـ ADMIN_IDS فقط
- تسجيل كامل لجميع العمليات
- دعم rollback عبر admin_audit (القيم القديمة محفوظة)

## Testing

سيتم إضافة اختبارات في `SystemChecker`:
- اختبار preview (عرض بدون تنفيذ)
- اختبار apply (تنفيذ فعلي على بيانات تجريبية)
- اختبار rollback (استعادة القيم القديمة)
- اختبار audit logging (التأكد من التسجيل)
